ORCA/M Asm65816 2.1.0

0001 5609
0002 5609              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0003 5609              ;	by EdAsmCvtIIGS version 1.2d7 on 5/16/91 at 1:23:13 PM
0004 5609
0005 5609                       TITLE 'Disk ][ boot code'
0006 5609 A9 60        D2RECAL: LDA   #$60
0007 560B AA                    TAX   
0008 560C 86 2B                 STX   slotz
0009 560E 85 4F                 STA   bootdev
0010 5610 BD 8E C0              LDA   |$C08E,x                 ; prepare IWM for read mode
0011 5613 BD 8C C0              LDA   |$C08C,x
0012 5616 B9 EA C0              LDA   |$C0EA,y                 ; select drive
0013 5619 BD 89 C0              LDA   |$C089,x
0014 561C A0 50                 LDY   #$50
0015 561E BD 80 C0     SEEKZERO LDA   |$C080,x
0016 5621 98                    TYA   
0017 5622 29 03                 AND   #$03
0018 5624 0A                    ASL   a
0019 5625 05 2B                 ORA   slotz
0020 5627 AA                    TAX   
0021 5628 BD 81 C0              LDA   |$C081,x
0022 562B A9 56                 LDA   #$56
0023 562D 08                    PHP                            ; save interrupt state and disable
0024 562E 78                    SEI   
0025 562F 20 A8 FC              JSR   |wait
0026 5632 28                    PLP   
0027 5633 88                    DEY   
0028 5634 10 E8                 BPL   seekzero
0029 5636 85 26                 STA   $26
0030 5638 85 3D                 STA   $3D
0031 563A 85 41                 STA   $41
0032 563C 18                    CLC                            ;assume no error
0033 563D A0 32                 LDY   #50
0034 563F BD 8C C0     DSKCHK0  LDA   |$C08C,x                 ;read data
0035 5642 30 04                 BMI   dskchk1                  ;if got data
0036 5644 88                    DEY                            ;else maybe timeout
0037 5645 10 F8                 BPL   dskchk0                  ;maybe not
0038 5647 38                    SEC                            ;maybe so, oops, error
0039 5648 08           DSKCHK1  PHP   
0040 5649 A2 03        MAKTBL   LDX   #$03
0041 564B A0 00                 LDY   #0
0042 564D 86 3C        TBLLOOP  STX   boottmp
0043 564F 8A                    TXA   
0044 5650 0A                    ASL   a
0045 5651 24 3C                 BIT   boottmp
0046 5653 F0 11                 BEQ   nopatrn
0047 5655 05 3C                 ORA   boottmp
0048 5657 49 FF                 EOR   #$FF
0049 5659 29 7E                 AND   #$7E
0050 565B B0 09        TBLLOOP2 BCS   nopatrn
0051 565D 4A                    LSR   a
0052 565E D0 FB                 BNE   tblloop2
0053 5660 98                    TYA   
0054 5661 9F 56 03 00           STA   >dnibl,x
0055 5665 C8                    INY   
0056 5666 E8           NOPATRN  INX   
0057 5667 10 E4                 BPL   tblloop
0058 5669 A9 08                 LDA   #$08
0059 566B 85 27                 STA   $27
0060 566D A0 7F                 LDY   #$7F
0061 566F 28                    PLP   
0062 5670 6B                    RTL   
0063 5671
0064 5671 A9 00        D2BOOTERR: LDA   #0
0065 5673 8F B1 0F E1           STA   >retry
0066 5677 4C 12 61              JMP   |booterr
0067 567A
0068 567A                       TITLE 'Send a CBus Packet'
0069 567A
0070 567A              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0071 567A              ;	by EdAsmCvtIIGS version 1.2d7 on 5/16/91 at 1:23:51 PM
0072 567A
0073 567A              ********************************************************
0074 567A              *                                                      *
0075 567A              *  SendOnePack                   Send a CBus Packet    *
0076 567A              *                                                      *
0077 567A              *    This routine sends a packet of data across the    *
0078 567A              *  bus.  The protocol is as follows:                   *
0079 567A              *              ____________________________            *
0080 567A              *  REQ _______|2                          5|_________  *
0081 567A              *          _______________________________             *
0082 567A              * /BSY ___|1               3             4|__________  *
0083 567A              *                                                      *
0084 567A              *    1)  Device signals ready for data                 *
0085 567A              *    2)  Host signals data iminent                     *
0086 567A              *    3)  Packet is transmitted (sync, command mark,    *
0087 567A              *         ids, contents, checksum [msb=1])             *
0088 567A              *    4)  Device signals packet recieved                *
0089 567A              *    5)  Host finishes send data cycle                 *
0090 567A              *                                                      *
0091 567A              *    The bytes are sent in slow mode (32 cycles/byte)  *
0092 567A              *  and the timing is critical.  Branches which should  *
0093 567A              *  not cross page boundaries are marked.               *
0094 567A              *                                                      *
0095 567A              *   Input:  buffer (2 bytes) <- ptr to data to send    *
0096 567A              *           bytecount (2)    <- length (bytes) of data *
0097 567A              *           packettype (1)   <- command or data packet *
0098 567A              *           CMDUnit (1)      <- # of device to receive *
0099 567A              *                                                      *
0100 567A              *   Output: carry set- handshake error                 * 
0101 567A              *                 clr- bytes sent                      *
0102 567A              *                                                      *
0103 567A              ********************************************************
0104 567A              SENDONEPACK EQU   *
0105 567A              *
0106 567A              * Prep for the transmission
0107 567A 20 7C 5A              JSR   WritePrep                ;Does a bunch of stuff
0108 567D              *
0109 567D              * Enable PC chain.
0110 567D A2 60                 LDX   #$60                     ;set X = slot * 16           
0111 567F A0 07                 LDY   #$07                     ;now set IWM mode before toggle
0112 5681 20 4C 5B              JSR   SetIWMode                ;                   
0113 5684 20 2B 60              JSR   SetBankE1                ;set bank for I/O access
0114 5687 BD 8A C0              LDA   |enable1,x               ;disable Unified drive
0115 568A BD 89 C0              LDA   |monset,x
0116 568D BD 88 C0              LDA   |monclr,x
0117 5690 20 C4 59              JSR   enablechain              ;This sets X reg
0118 5693 20 2B 60              JSR   SetBankE1                ;set bank for I/O access
0119 5696 BD 8A C0              LDA   |enable1,x               ;smart port is drive 1 on Cortland
0120 5699 BD 89 C0              LDA   |monset,x
0121 569C              *
0122 569C              * Loop until the chain becomes unbusy
0123 569C AF 36 C0 00           LDA   >cyareg
0124 56A0 EB                    XBA   
0125 56A1 29 7F                 AND   #$7F
0126 56A3 8F 36 C0 00           STA   cyareg                   ;slow down to 1Mhz for busy polling
0127 56A7 A0 32                 LDY   #bsyto1                  ;Timeout = .55 mSec
0128 56A9 BD 8E C0     UBSY1    LDA   |l7clr,x                 ;Test if /BSY is hi or lo
0129 56AC 30 0D                 BMI   chainunbsy               ;If hi, bus is not busy
0130 56AE 88                    DEY   
0131 56AF D0 F8                 BNE   ubsy1                    ;Keep trying
0132 56B1              *
0133 56B1 EB                    XBA   
0134 56B2 8F 36 C0 00           STA   cyareg                   ;restore speed
0135 56B6 EB                    XBA                            ;get a back
0136 56B7 38                    SEC   
0137 56B8 4C E9 57              JMP   sd10
0138 56BB              *
0139 56BB              * Tell the bus that data is coming and send the sync bytes
0140 56BB              *  Sync is groups of eight 2's separated by a 6 (micS cell)
0141 56BB              *  (111111110011111111001111111100 ...)
0142 56BB              *
0143 56BB              CHAINUNBSY EQU   *
0144 56BB EB                    XBA   
0145 56BC 8F 36 C0 00           STA   cyareg
0146 56C0              *
0147 56C0 BD 81 C0              LDA   |reqset,x                ;Raise REQ
0148 56C3 A0 05                 LDY   #5                       ;Sync plus packet begin
0149 56C5              *
0150 56C5 A9 FF                 LDA   #$FF                     ;Send out the 1st byte sync
0151 56C7 9D 8F C0              STA   |l7set,x
0152 56CA              *
0153 56CA              SSB      EQU   *
0154 56CA B9 E8 C5              LDA   preamble,y
0155 56CD              SSD      EQU   *
0156 56CD 1E 8C C0              ASL   |l6clr,x                 ;Wait 'til buffer empty
0157 56D0 90 FB                 BCC   ssd
0158 56D2              *
0159 56D2 9D 8D C0              STA   |l6set,x
0160 56D5 88                    DEY   
0161 56D6 10 F2                 BPL   ssb                      ;Back for more bytes
0162 56D8              *
0163 56D8              * Send over the desination ID
0164 56D8 A5 60                 LDA   Unit
0165 56DA 09 80                 ORA   #$80                     ;Make the device ID
0166 56DC 20 7D 59              JSR   sendbyte
0167 56DF              *
0168 56DF              * Send the source ID (that's us... we're an $80)
0169 56DF 20 7B 59              JSR   send80
0170 56E2              *
0171 56E2              * Send over the packet type (command or data)
0172 56E2 A5 61                 LDA   Wpackettype
0173 56E4 20 7D 59              JSR   sendbyte
0174 56E7              *
0175 56E7              * Send the Auxilliary Type byte (an $80 from this rev PC)
0176 56E7 20 7B 59              JSR   Send80
0177 56EA              *
0178 56EA              * Send the status byte (null for us), and length bytes
0179 56EA 20 7B 59              JSR   send80
0180 56ED A5 4F                 LDA   oddbytes
0181 56EF 09 80                 ORA   #$80
0182 56F1 20 7D 59              JSR   sendbyte
0183 56F4 A5 4E                 LDA   grp7ctr
0184 56F6 09 80                 ORA   #$80
0185 56F8 20 7D 59              JSR   sendbyte
0186 56FB              *
0187 56FB              * Now send the "oddbytes" part of the packet contents
0188 56FB A5 4F                 LDA   oddbytes                 ;Get # of "odd" bytes
0189 56FD F0 10                 BEQ   sob2                     ;Skip if no odd bytes
0190 56FF              *
0191 56FF A0 FF                 LDY   #$FF
0192 5701 A5 5F                 LDA   tbodd                    ;Get the odd bytes msb's (A[7]=1)
0193 5703              *
0194 5703              SOB1     EQU   *
0195 5703 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0196 5706 C8                    INY   
0197 5707 B7 57                 LDA   [buffer],y               ;Get the data byte
0198 5709 09 80                 ORA   #$80                     ;Flip on the hi bit
0199 570B C4 4F                 CPY   oddbytes                 ;Are we done?
0200 570D 90 F4                 BLT   sob1
0201 570F              *
0202 570F              * Now send over the groups of seven contents
0203 570F              * Currently assume there must be at least one group of 'em
0204 570F              SOB2     EQU   *
0205 570F A5 4E                 LDA   grp7ctr                  ;Check if there are groups to send
0206 5711 D0 03                 BNE   sob3                     ;=> At least one group
0207 5713 4C A3 57              JMP   datdone                  ;Skip to send checksum
0208 5716              *
0209 5716              SOB3     EQU   *
0210 5716 A0 00                 LDY   #0
0211 5718 A5 41        START    LDA   topbits
0212 571A 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0213 571D              *
0214 571D              * Send first byte
0215 571D A5 50                 LDA   next1
0216 571F 09 80                 ORA   #$80
0217 5721 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0218 5724              *
0219 5724              * Prep the next "1st" byte for next time
0220 5724 B7 5B                 LDA   [buffer2],y
0221 5726 85 50                 STA   next1
0222 5728 0A                    ASL   a
0223 5729 26 41                 ROL   topbits                  ;Store the top bit
0224 572B C8                    INY                            ;Next byte
0225 572C              *
0226 572C              * It's possible that we're at a page boundary now. If so, bump the
0227 572C              *  hi order part of the pointer.
0228 572C D0 04                 BNE   skip1
0229 572E E6 5C                 INC   buffer2+1
0230 5730 80 02                 BRA   skip2
0231 5732 48           SKIP1    PHA                            ;Equalize the cases
0232 5733 68                    PLA   
0233 5734              *
0234 5734              * Push us ahead by an additional 8 cycles for margin reasons
0235 5734              *  Plus I gotta get the topbits MSB set somehow...
0236 5734              SKIP2    EQU   *
0237 5734 A9 02                 LDA   #%00000010               ;Flip what will be MSB
0238 5736 05 41                 ORA   topbits
0239 5738 85 41                 STA   topbits
0240 573A              *
0241 573A              * Send the second byte
0242 573A A5 51                 LDA   next2
0243 573C 09 80                 ORA   #$80
0244 573E 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0245 5741 B7 5B                 LDA   [buffer2],y
0246 5743 85 51                 STA   next2
0247 5745 0A                    ASL   a
0248 5746 26 41                 ROL   topbits                  ;Store the top bit
0249 5748 C8                    INY                            ;Next byte
0250 5749              *
0251 5749              * Send the third byte
0252 5749 A5 52                 LDA   next3
0253 574B 09 80                 ORA   #$80
0254 574D 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0255 5750 B7 5B                 LDA   [buffer2],y
0256 5752 85 52                 STA   next3
0257 5754 0A                    ASL   a
0258 5755 26 41                 ROL   topbits                  ;Store the top bit
0259 5757 C8                    INY                            ;Next byte
0260 5758              *
0261 5758              * Send the fourth byte
0262 5758              *
0263 5758 A5 53                 LDA   next4
0264 575A 09 80                 ORA   #$80
0265 575C 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0266 575F B7 5B                 LDA   [buffer2],y
0267 5761 85 53                 STA   next4
0268 5763 0A                    ASL   a
0269 5764 26 41                 ROL   topbits                  ;Store the top bit
0270 5766 C8                    INY                            ;Next byte
0271 5767              *
0272 5767              * After the first 256 bytes, we will cross pages here.  If we did
0273 5767              *  cross, bump the buffer pointer. If not, equalize the cases with 
0274 5767              *  seven cycles of time wasting.
0275 5767 D0 04                 BNE   skip3
0276 5769 E6 5C                 INC   buffer2+1
0277 576B 80 02                 BRA   skip4
0278 576D 48           SKIP3    PHA   
0279 576E 68                    PLA   
0280 576F              SKIP4    EQU   *
0281 576F              *
0282 576F              * Send the fifth byte
0283 576F A5 54                 LDA   next5
0284 5771 09 80                 ORA   #$80
0285 5773 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0286 5776 B7 5B                 LDA   [buffer2],y
0287 5778 85 54                 STA   next5
0288 577A 0A                    ASL   a
0289 577B 26 41                 ROL   topbits                  ;Store the top bit
0290 577D C8                    INY                            ;Next byte
0291 577E              *
0292 577E              * Send the sixth byte
0293 577E A5 55                 LDA   next6
0294 5780 09 80                 ORA   #$80
0295 5782 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0296 5785 B7 5B                 LDA   [buffer2],y
0297 5787 85 55                 STA   next6
0298 5789 0A                    ASL   a
0299 578A 26 41                 ROL   topbits                  ;Store the top bit
0300 578C C8                    INY                            ;Next byte
0301 578D              *
0302 578D              * Send the last byte of the group
0303 578D A5 56                 LDA   next7
0304 578F 09 80                 ORA   #$80
0305 5791 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0306 5794 B7 5B                 LDA   [buffer2],y
0307 5796 85 56                 STA   next7
0308 5798 0A                    ASL   a
0309 5799 26 41                 ROL   topbits                  ;Store the top bit
0310 579B C8                    INY                            ;Next byte
0311 579C              *
0312 579C              * Now see if we have sent enough groups of seven
0313 579C C6 4E                 DEC   grp7ctr
0314 579E F0 03                 BEQ   datdone
0315 57A0              *
0316 57A0              * Otherwise, back to do more.  Note it's too far for a branch.
0317 57A0 4C 18 57              JMP   start
0318 57A3              *
0319 57A3              * Whew! Now send the damn checksum as two FM bytes
0320 57A3              DATDONE  EQU   *
0321 57A3 A5 40                 LDA   checksum                 ;c7 c6 c5 c4 c3 c2 c1 c0
0322 57A5 09 AA                 ORA   #$AA                     ; 1 c6  1 c4  1 c2  1 c0
0323 57A7 20 FD 57              JSR   WritIWM                  ;When it's time, write it
0324 57AA              *
0325 57AA A5 40                 LDA   checksum                 ;c7 c6 c5 c4 c3 c2 c1 c0
0326 57AC 4A                    LSR   a                        ; 0 c7 c6 c5 c4 c3 c2 c1
0327 57AD 09 AA                 ORA   #$AA                     ; 1 c7  1 c5  1 c3  1 c1
0328 57AF 20 7D 59              JSR   sendbyte
0329 57B2              *
0330 57B2              * Send the end of packet mark
0331 57B2 A9 C8                 LDA   #packetend
0332 57B4 20 7D 59              JSR   sendbyte
0333 57B7              *
0334 57B7              * Wait until write underflow
0335 57B7              SD7      EQU   *
0336 57B7 BD 8C C0              LDA   |l6clr,x
0337 57BA 29 40                 AND   #$40
0338 57BC D0 F9                 BNE   sd7                      ;Still writing data
0339 57BE              *
0340 57BE 9D 8D C0              STA   |l6set,x                 ;Back to sense mode (dummy write)
0341 57C1              *
0342 57C1              * Now wait until the drive acknowledges reciept of the
0343 57C1              *  string or until timeout
0344 57C1 A0 0A                 LDY   #bsyto2                  ;Load timeout for bsy low (100uS)
0345 57C3 AF 36 C0 00           LDA   cyareg
0346 57C7 EB                    XBA   
0347 57C8                       LDA   cyareg
0348 57C8 29 7F                 AND   #$7F
0349 57CA 8F 36 C0 00           STA   cyareg                   ;shift down to 1mhz for polling
0350 57CE 88           @10      DEY                            ;A little closer to an error 
0351 57CF F0 0C                 BEQ   sd9                      ;Oops it didn't happen
0352 57D1              *
0353 57D1              * See if drive has acknowledged the bytes yet
0354 57D1 BD 8E C0              LDA   |l7clr,x                 ;Wait 'til /BSY lo 
0355 57D4 30 F8                 BMI   @10
0356 57D6 EB                    XBA   
0357 57D7 8F 36 C0 00           STA   cyareg                   ;restore original speed
0358 57DB 80 0C                 BRA   sd10
0359 57DD              *
0360 57DD              * Too much time has elapsed.  Drive didn't get string.
0361 57DD EB           SD9      XBA   
0362 57DE 8F 36 C0 00           STA   cyareg
0363 57E2 A9 01                 LDA   #noanswer                ;Report error in comm error byte 
0364 57E4              DBERROR  EQU   *
0365 57E4 A2 60                 LDX   #$60                     ;For dberror entry
0366 57E6 38                    SEC                            ;Signal a problem 
0367 57E7 80 01                 BRA   sd11
0368 57E9              *
0369 57E9              * Finish the sequence
0370 57E9 18           SD10     CLC                            ;This is a normal exit 
0371 57EA BD 80 C0     SD11     LDA   |reqclr,x                ;Set REQ lo
0372 57ED BD 8C C0              LDA   |l6clr,x                 ;Back into read mode
0373 57F0              *
0374 57F0              * Pull back the bytecount in all cases
0375 57F0 4B                    PHK                            ;data bank to $FF
0376 57F1 AB                    PLB   
0377 57F2 60                    RTS   
0378 57F3                       EJECT 
0379 57F3              *
0380 57F3              * These routines are for wasting specific amounts of time
0381 57F3              *  This code segment should not cross page boundaries.
0382 57F3              *
0383 57F3 20 F8 57     WASTE32  JSR   waste14
0384 57F6 EA           WASTE18  NOP   
0385 57F7 EA           WASTE16  NOP   
0386 57F8 EA           WASTE14  NOP   
0387 57F9 60           WASTE12  RTS   
0388 57FA              *
0389 57FA              MARKERR  EQU   *
0390 57FA 4C E4 57              JMP   dberror
0391 57FD              *
0392 57FD              WritIWM  EQU   *
0393 57FD 1E 8C C0              ASL   |l6clr,x                 ;do write handshake
0394 5800 90 FB                 BCC   WritIWM                  ;if not ready
0395 5802 9D 8D C0              STA   |l6set,x                 ;else time to write
0396 5805 60                    RTS   
0397 5806                       TITLE 'Receive a CBus Packet'
0398 5806
0399 5806              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0400 5806              ;	by EdAsmCvtIIGS version 1.2d7 on 5/16/91 at 1:24:23 PM
0401 5806
0402 5806              ********************************************************
0403 5806              *                                                      *
0404 5806              *  ReceivePack       Get a packet from bus resident    *
0405 5806              *                                                      *
0406 5806              *              ____________________________            *
0407 5806              *  REQ _______|2                          5|_________  *
0408 5806              *          _______________________________             *
0409 5806              * /BSY ___|1               3             4|__________  *
0410 5806              *                                                      *
0411 5806              *    1)  Drive signals ready to send packet            *
0412 5806              *    2)  Host signals ready to recieve data            *
0413 5806              *    3)  Packet is transmitted (sync, mark, IDs, data, *
0414 5806              *         checksum [msb=1])                            *
0415 5806              *    4)  Drive signals packet dispatched               *
0416 5806              *    5)  Host acknowledges reciept of packet           *
0417 5806              *                                                      *
0418 5806              *    The bytes are sent in slow mode (32 cycles/byte)  *
0419 5806              *  and the timing is critical.  Branches which should  *
0420 5806              *  not cross page boundaries are marked.               *
0421 5806              *                                                      *
0422 5806              *   Input:  buffer <- address where packet guts left   *
0423 5806              *                                                      *
0424 5806              *   Output: carry set- handshake error                 * 
0425 5806              *                 clr- bytes recieved                  *
0426 5806              *           A <- error0 if carry set                   *
0427 5806              *                                                      *
0428 5806              ********************************************************
0429 5806              *
0430 5806              GRABSTATUS EQU   *
0431 5806              RECEIVEPACK EQU   *
0432 5806              *
0433 5806              * Init the checksum
0434 5806              *
0435 5806 A9 00                 LDA   #$00
0436 5808 85 40                 STA   checksum
0437 580A              *
0438 580A              * Copy over buffer -> buffer2
0439 580A              *
0440 580A A5 57                 LDA   buffer
0441 580C 85 5B                 STA   buffer2
0442 580E A5 58                 LDA   buffer+1
0443 5810 85 5C                 STA   buffer2+1
0444 5812 A5 59                 LDA   buffer+2
0445 5814 85 5D                 STA   buffer2+2
0446 5816              *
0447 5816              *
0448 5816 20 C4 59              JSR   enablechain              ;Set X register to $N0
0449 5819              *
0450 5819 20 2B 60              JSR   SetBankE1                ;data bank to $E1
0451 581C BD 8D C0              LDA   |l6set,x                 ;Prep for sense mode 
0452 581F              *
0453 581F              * Now wait for BSY to go hi, signalling 'ready w/ status' 
0454 581F              *
0455 581F BD 8E C0     RDH0     LDA   |l7clr,x                 ;Read sense
0456 5822 30 07                 BMI   rdh1                     ;No window if packet coming
0457 5824 20 4F 59              JSR   OpenWndw                 ;open the interrupt window
0458 5827 A2 60                 LDX   #$60
0459 5829 80 F4                 BRA   rdh0                     ;then see if packet is coming
0460 582B              *
0461 582B              * Signal Liron we're ready to recieve
0462 582B              *
0463 582B              RDH1     EQU   *
0464 582B BD 81 C0              LDA   |reqset,x                ;Raise /REQ 
0465 582E A0 00                 LDY   #$00                     ;max left til stat mark
0466 5830              *
0467 5830              * Wait for a byte from Liron or timeout 
0468 5830              *
0469 5830              RDH2     EQU   *
0470 5830 AF EC C0 E1           LDA   >IWMl6clr                ;wait for valid IWM data, and read it
0471 5834 88                    DEY   
0472 5835 F0 C3                 BEQ   markerr                  ;Didn't find a packet in time
0473 5837              *
0474 5837              * Is it the beginning of the packet?
0475 5837              *
0476 5837              RDH21    EQU   *
0477 5837 C9 C3                 CMP   #packetbeg               ;Find the packet begin mark
0478 5839 D0 F5                 BNE   rdh2                     ;Back again - no timeout for now
0479 583B              *
0480 583B              * Okay load up the table with this stuff
0481 583B              *
0482 583B              RDH5     EQU   *
0483 583B              *
0484 583B A0 06                 LDY   #6                       ;Seven bytes of overhead
0485 583D              RDH3     EQU   *
0486 583D 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0487 5840 29 7F                 AND   #%01111111               ;Strip start bit
0488 5842 F4 00 00              PEA   |$0000                   ;data bank to $00
0489 5845 AB                    PLB   
0490 5846 AB                    PLB   
0491 5847 99 4E 00              STA   |rcvbuf,y
0492 584A 49 80                 EOR   #$80                     ;Pop MSB back on for checksum
0493 584C 45 40                 EOR   checksum
0494 584E 85 40                 STA   checksum
0495 5850 88                    DEY   
0496 5851 10 EA                 BPL   rdh3
0497 5853              *
0498 5853              * Set groups of seven buffer pointer buffer2
0499 5853              *
0500 5853 A5 4F                 LDA   oddbytes
0501 5855 F0 27                 BEQ   start25                  ;Skip alteration if no oddbytes
0502 5857 18                    CLC   
0503 5858 65 57                 ADC   buffer
0504 585A 85 5B                 STA   buffer2
0505 585C A5 58                 LDA   buffer+1
0506 585E 69 00                 ADC   #0
0507 5860 85 5C                 STA   buffer2+1
0508 5862              *
0509 5862 A0 00                 LDY   #0
0510 5864              *
0511 5864              * Now receive the odd bytes
0512 5864              *
0513 5864 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0514 5867 0A                    ASL   a                        ;Pop off the start bit
0515 5868 85 41                 STA   topbits
0516 586A              START1   EQU   *
0517 586A 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0518 586D 06 41                 ASL   topbits                  ;Get an MSB
0519 586F B0 02                 BCS   gob1                     ;If MSB set, leave start bit
0520 5871 49 80                 EOR   #$80                     ;MSB clear- flip start bit
0521 5873 97 57        GOB1     STA   [buffer],y               ;Squirrel it away
0522 5875 45 40                 EOR   checksum                 ;add it to the checksum
0523 5877 85 40                 STA   checksum
0524 5879 C8                    INY                            ;Next spot
0525 587A C4 4F                 CPY   oddbytes                 ;Are we done?
0526 587C 90 EC                 BLT   start1                   ;If more, branch
0527 587E              *
0528 587E              *
0529 587E              SLOTDEPRD EQU   *
0530 587E              START25  EQU   *
0531 587E A0 00                 LDY   #0
0532 5880 A5 4E                 LDA   grp7ctr
0533 5882 48                    PHA                            ;Save group counter for later
0534 5883 D0 03                 BNE   start35
0535 5885 4C 0C 59              JMP   done5                    ;Go get the checksum
0536 5888              *
0537 5888              * Okay, get the groups of seven
0538 5888              *  Start by getting the topbits for this group of seven
0539 5888              *
0540 5888              START35  EQU   *
0541 5888 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0542 588B 85 5F                 STA   temp                     ;Just a second
0543 588D              *
0544 588D              * Split up the seven bits into two indices for topbit tables
0545 588D              *
0546 588D 4A                    LSR   a                        ;0   1  d1  d2  d3  d4  d5  d6
0547 588E 4A                    LSR   a                        ;0   0   1  d1  d2  d3  d4  d5
0548 588F 4A                    LSR   a                        ;0   0   0   1  d1  d2  d3  d4
0549 5890 29 0F                 AND   #%00001111               ;0   0   0   0  d1  d2  d3  d4
0550 5892 AA                    TAX                            ;First index into the tables
0551 5893 A5 5F                 LDA   temp                     ;1  d1  d2  d3  d4  d5  d6  d7
0552 5895 29 07                 AND   #%00000111               ;0   0   0   0   0  d5  d6  d7
0553 5897 85 5F                 STA   temp                     ;Keep for last three bytes
0554 5899              *
0555 5899              * Now read the first byte, reunite its msb, store it, and checksum it.
0556 5899              *
0557 5899 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0558 589C 5F A8 C5 00           EOR   >shift1,x                ;Recombine the MSB with data
0559 58A0 97 5B                 STA   [buffer2],y              ;Store it away
0560 58A2 45 40                 EOR   checksum                 ;Add it to the checksum
0561 58A4 85 40                 STA   checksum
0562 58A6 C8                    INY   
0563 58A7              *
0564 58A7              * Now, the second Y turn over occurs at this point in the loop.  Update
0565 58A7              *  the buffer pointer if it occurred.
0566 58A7              *
0567 58A7 D0 02                 BNE   *+4
0568 58A9 E6 5C                 INC   buffer2+1
0569 58AB              *
0570 58AB              * Now the second byte
0571 58AB              *
0572 58AB 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0573 58AE 5F B8 C5 00           EOR   >shift2,x                ;Recombine the MSB with data
0574 58B2 97 5B                 STA   [buffer2],y              ;Store it away
0575 58B4 45 40                 EOR   checksum                 ;Add it to the checksum
0576 58B6 85 40                 STA   checksum
0577 58B8 C8                    INY   
0578 58B9              *
0579 58B9              * Now the third byte
0580 58B9              *
0581 58B9 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0582 58BC 5F C8 C5 00           EOR   >shift3,x                ;Recombine the MSB with data
0583 58C0 97 5B                 STA   [buffer2],y              ;Store it away
0584 58C2 45 40                 EOR   checksum                 ;Add it to the checksum
0585 58C4 85 40                 STA   checksum
0586 58C6 C8                    INY   
0587 58C7              *
0588 58C7              * Now the fourth byte
0589 58C7              *
0590 58C7 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0591 58CA 5F D8 C5 00           EOR   >shift4,x                ;Recombine the MSB with data
0592 58CE 97 5B                 STA   [buffer2],y              ;Store it away
0593 58D0 45 40                 EOR   checksum                 ;Add it to the checksum
0594 58D2 85 40                 STA   checksum
0595 58D4 C8                    INY   
0596 58D5              *
0597 58D5              * The first Y turn over occurs at this point in the loop.  Update
0598 58D5              *  the buffer pointer if it occurred.
0599 58D5              *
0600 58D5 D0 02                 BNE   *+4
0601 58D7 E6 5C                 INC   buffer2+1
0602 58D9              *
0603 58D9 A6 5F                 LDX   temp                     ;Now we need the other index
0604 58DB              *
0605 58DB              * Now the fifth byte
0606 58DB              *
0607 58DB 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0608 58DE 5F B8 C5 00           EOR   >shift2,x                ;Recombine the MSB with data
0609 58E2 97 5B                 STA   [buffer2],y              ;Store it away
0610 58E4 45 40                 EOR   checksum                 ;Add it to the checksum
0611 58E6 85 40                 STA   checksum
0612 58E8 C8                    INY   
0613 58E9              *
0614 58E9              * Now the sixth byte
0615 58E9              *
0616 58E9 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0617 58EC 5F C8 C5 00           EOR   >shift3,x                ;Recombine the MSB with data
0618 58F0 97 5B                 STA   [buffer2],y              ;Store it away
0619 58F2 45 40                 EOR   checksum                 ;Add it to the checksum
0620 58F4 85 40                 STA   checksum
0621 58F6 C8                    INY   
0622 58F7              *
0623 58F7              * And, finally, the seventh byte
0624 58F7              *
0625 58F7 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0626 58FA 5F D8 C5 00           EOR   >shift4,x                ;Recombine the MSB with data
0627 58FE 97 5B                 STA   [buffer2],y              ;Store it away
0628 5900 45 40                 EOR   checksum                 ;Add it to the checksum
0629 5902 85 40                 STA   checksum
0630 5904 C8                    INY   
0631 5905              *
0632 5905              * Now see if this is the last group of seven to receive
0633 5905              *
0634 5905 C6 4E                 DEC   grp7ctr
0635 5907 F0 03                 BEQ   done5                    ;Go to get the checksum etc
0636 5909 4C 88 58              JMP   start35                  ;Another topbits ...
0637 590C              *
0638 590C              * Get and reconstruct the checksum
0639 590C              *
0640 590C              DONE5    EQU   *
0641 590C 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0642 590F 85 5F                 STA   temp                     ;1 c6 1 c4 1 c2 1 c0
0643 5911              *
0644 5911 68                    PLA                            ;Get back the groups of 7 ctr
0645 5912 85 4E                 STA   grp7ctr
0646 5914 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0647 5917 38                    SEC   
0648 5918 2A                    ROL   a                        ;c7 1 c5 1 c3 1 c1 1
0649 5919 25 5F                 AND   temp                     ;c7 c6 c5 c4 c3 c2 c1 c0
0650 591B 45 40                 EOR   checksum                 ;When we're done, should be zero
0651 591D AA                    TAX                            ;save checksum
0652 591E              *
0653 591E              * Get the packet end mark. Is it correct?
0654 591E              *
0655 591E 20 44 59              JSR   RdIWM                    ;wait for valid IWM data, and read it
0656 5921              *
0657 5921 C9 C8                 CMP   #packetend
0658 5923 D0 16                 BNE   npenderr5
0659 5925              *
0660 5925              * Didn't have time before to checksum oddbytes.  Do it now
0661 5925              *  A still has the partial checksum
0662 5925              *
0663 5925 8A                    TXA                            ;get back checksum
0664 5926              *
0665 5926              * Okay, checksum oughta be zero.  If not, checksum error.
0666 5926              *
0667 5926              ICBT15   EQU   *
0668 5926 AA                    TAX   
0669 5927 D0 16                 BNE   cserror5
0670 5929              *
0671 5929              * Wait for /BSY to go low
0672 5929              *
0673 5929              LSTBSYWAIT5 EQU   *
0674 5929 20 2B 60              JSR   SetBankE1
0675 592C AD ED C0              LDA   |l6set+TheOff
0676 592F AD EE C0     RDH45    LDA   |l7clr+TheOff
0677 5932 30 FB                 BMI   rdh45
0678 5934              *
0679 5934              * Got the bytes, now acknowledge their reciept
0680 5934              *
0681 5934 AD E0 C0              LDA   |reqclr+TheOff           ;Lower REQ 
0682 5937              *
0683 5937 18                    CLC   
0684 5938 4B           RDHBYE   PHK                            ;data bank to $FF
0685 5939 AB                    PLB   
0686 593A 60                    RTS   
0687 593B              *
0688 593B A9 20        NPENDERR5 LDA   #nopackend
0689 593D D0 02                 BNE   gserror5
0690 593F A9 10        CSERROR5 LDA   #csumerr
0691 5941              GSERROR5 EQU   *
0692 5941 38                    SEC   
0693 5942 80 F4                 BRA   rdhbye
0694 5944              *
0695 5944              * This routine reads the data from the
0696 5944              * IWM, and returns the data in the A-Reg
0697 5944              * with the data bank set to $FF.
0698 5944              * Execution time = 25 cycles minimum or
0699 5944              * 8.75uS (assuming 350nS/Cycle).
0700 5944              *
0701 5944              RDIWM    EQU   *
0702 5944 F4 E1 FF              PEA   |$FFE1
0703 5947 AB                    PLB                            ;set bank $E1
0704 5948 AD EC C0              LDA   |l6clr+TheOff
0705 594B 10 FB                 BPL   *-3
0706 594D AB                    PLB                            ;set bank $FF
0707 594E 60                    RTS   
0708 594F              *
0709 594F              *
0710 594F              * Open Interrupt Window
0711 594F              * NOTE: this takes about 800uS
0712 594F              *
0713 594F              OPENWNDW EQU   *
0714 594F AD C9 0F              LDA   |IntEnbl                 ;get entry interrupt enbl stat
0715 5952 29 04                 AND   #%00000100               ;check flag
0716 5954 D0 24                 BNE   CloseWndw                ;don't do if not needed
0717 5956 20 89 60              JSR   SavFWzp                  ;Save ours and restore his to
0718 5959 20 63 60              JSR   ResSysZp                 ;get ready to open IRQ window
0719 595C AD CC 0F              LDA   |CyaSave                 ; restore CYA for IRQ
0720 595F 8D 36 C0              STA   |CyaReg
0721 5962 58                    CLI                            ;enable interrupts
0722 5963 EA                    NOP                            ;WARNING-Liron gets sleepy if away to long
0723 5964 78                    SEI                            ;Close IRQ window
0724 5965 AD 36 C0              LDA   |CyaReg                  ; save new CYA state
0725 5968 8D CC 0F              STA   |CyaSave                 ; in case control panel changes speed
0726 596B 29 FB                 AND   #%11111011               ; fast mode & disable slot 6 motor detect
0727 596D 09 80                 ORA   #%10000000
0728 596F 8D 36 C0              STA   |CyaReg
0729 5972 E2 30                 SEP   #$30                     ;make sure in 8 bit mode
0730 5974 20 31 60              JSR   SavSyszp                 ;save system before getting FW
0731 5977 20 9C 60              JSR   ResFwZp                  ;and restore firmware environment
0732 597A              CLOSEWNDW EQU   *
0733 597A 60                    RTS   
0734 597B                       TITLE 'More Packet Stuff'
0735 597B
0736 597B              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0737 597B              ;	by EdAsmCvtIIGS version 1.2d7 on 5/16/91 at 1:24:55 PM
0738 597B
0739 597B              *
0740 597B              * Data bank must be $E1 before
0741 597B              * you get to here !!!
0742 597B              *
0743 597B              SEND80   EQU   *
0744 597B A9 80                 LDA   #$80
0745 597D              SENDBYTE EQU   *
0746 597D BC 8C C0              LDY   |l6clr,x
0747 5980 10 FB                 BPL   SendByte
0748 5982 9D 8D C0              STA   |l6set,x
0749 5985 45 40                 EOR   checksum
0750 5987 85 40                 STA   checksum
0751 5989 60                    RTS   
0752 598A              *
0753 598A              *
0754 598A              *
0755 598A              *
0756 598A              RESETCHAIN EQU   *
0757 598A 20 D2 59              JSR   ClrPhases
0758 598D 20 2B 60              JSR   SetBankE1                ;data bank to $E1
0759 5990 BD 81 C0              LDA   |reqset,x
0760 5993 BD 85 C0              LDA   |ca2set,x
0761 5996 A0 50                 LDY   #80                      ;Hard reset for 80 ms
0762 5998 20 A2 59              JSR   YMSWait
0763 599B              *
0764 599B 20 D2 59              JSR   ClrPhases
0765 599E 4B                    PHK                            ;data bank to $FF
0766 599F AB                    PLB   
0767 59A0              *
0768 59A0 A0 0A                 LDY   #10                      ;About 10 mS reset time!
0769 59A2              *
0770 59A2              YMSWAIT  EQU   *
0771 59A2 20 A9 59              JSR   OneMS
0772 59A5 88                    DEY   
0773 59A6 D0 FA                 BNE   YMSWait
0774 59A8 60                    RTS   
0775 59A9              *
0776 59A9              ONEMS    EQU   *
0777 59A9 48                    PHA   
0778 59AA AF 36 C0 00           LDA   >e1cyareg
0779 59AE 48                    PHA   
0780 59AF 29 7F                 AND   #$7F
0781 59B1 8F 36 C0 00           STA   >e1cyareg                ;shift down to 1Mhz mode
0782 59B5              *
0783 59B5 A2 64                 LDX   #100                     ;100*10cyc =977 us
0784 59B7 CA           @10      DEX                            ;(+2)
0785 59B8 EA                    NOP                            ;(+4)
0786 59B9 D0 00                 BNE   @15                      ;(+7)
0787 59BB D0 FA        @15      BNE   @10                      ;(+10)
0788 59BD              *
0789 59BD 68                    PLA   
0790 59BE 8F 36 C0 00           STA   >e1cyareg                ;shift back to original speed
0791 59C2 68                    PLA   
0792 59C3 60                    RTS   
0793 59C4              *
0794 59C4              * Drop ENBL1 first to deselect Unified
0795 59C4              * and then enable UniDisk.
0796 59C4              *
0797 59C4              ENABLECHAIN EQU   *
0798 59C4 A2 60                 LDX   #$60
0799 59C6 20 2B 60              JSR   SetBankE1                ;data bank to $E1
0800 59C9 BD 83 C0              LDA   |ca1set,x                ;now enable UniDisk
0801 59CC BD 87 C0              LDA   |lstrbset,x
0802 59CF 4B                    PHK                            ;data bank to $FF
0803 59D0 AB                    PLB   
0804 59D1 60                    RTS   
0805 59D2              *
0806 59D2              *
0807 59D2              CLRPHASES EQU   *
0808 59D2 A2 60                 LDX   #$60
0809 59D4 20 2B 60              JSR   SetBankE1                ;data bank to $E1
0810 59D7 BD 80 C0              LDA   |reqclr,x
0811 59DA BD 82 C0              LDA   |ca1clr,x
0812 59DD BD 84 C0              LDA   |ca2clr,x
0813 59E0 BD 86 C0              LDA   |lstrbclr,x
0814 59E3 4B                    PHK                            ;data bank to $FF
0815 59E4 AB                    PLB   
0816 59E5 60                    RTS   
0817 59E6              *
0818 59E6              *
0819 59E6                       EJECT 
0820 59E6              *
0821 59E6              SENDDATA EQU   *
0822 59E6 A9 05                 LDA   #<RC2
0823 59E8 A0 00                 LDY   #>RC2
0824 59EA 20 0B 5A              JSR   SendPile
0825 59ED 90 05                 BCC   sdoubt
0826 59EF              COMRST   EQU   *
0827 59EF A9 80                 LDA   #CommReset
0828 59F1 20 03 5F              JSR   AssignID                 ;this restores Cbuss Unit #'s
0829 59F4              SDOUBT   EQU   *
0830 59F4 60                    RTS   
0831 59F5              *
0832 59F5              *
0833 59F5              SENDPACK EQU   *
0834 59F5 20 0B 5A              JSR   SendPile                 ;Try to send a pack
0835 59F8 90 FA                 BCC   sdoubt
0836 59FA 20 EF 59              JSR   ComRst                   ;Reset to try again
0837 59FD 4B                    PHK                            ; bank to FF or WRITEPREP fails
0838 59FE AB                    PLB   
0839 59FF              *
0840 59FF AF B9 0F E1           LDA   >SvBcL                   ;Get back the packetlength
0841 5A03 85 50                 STA   bytecountl
0842 5A05 AF BA 0F E1           LDA   >SvBcH
0843 5A09 85 51                 STA   bytecounth
0844 5A0B              *
0845 5A0B              SENDPILE EQU   *
0846 5A0B A9 E8                 LDA   #<RC1                    ;Retry count (big!) 3000
0847 5A0D A0 03                 LDY   #>RC1
0848 5A0F              *
0849 5A0F              ALTSENDPILE EQU   *
0850 5A0F 8F B1 0F E1           STA   >Retry
0851 5A13 98                    TYA   
0852 5A14 8F B3 0F E1           STA   >Retry2
0853 5A18              *
0854 5A18              * SendPack destroys the bytecount
0855 5A18              *
0856 5A18              SPILE1   EQU   *
0857 5A18 A5 50                 LDA   bytecountl
0858 5A1A 8F B9 0F E1           STA   >SvBcL
0859 5A1E A5 51                 LDA   bytecounth
0860 5A20 8F BA 0F E1           STA   >SvBcH
0861 5A24              *
0862 5A24 20 7A 56              JSR   SendOnePack              ;Send the packet
0863 5A27              *
0864 5A27 AF B9 0F E1           LDA   >SvBcL
0865 5A2B 85 50                 STA   bytecountl
0866 5A2D AF BA 0F E1           LDA   >SvBcH
0867 5A31 85 51                 STA   bytecounth
0868 5A33              *
0869 5A33 90 0F                 BCC   spilout
0870 5A35 8B                    PHB                            ;save data bank
0871 5A36 20 2B 60              JSR   SetBankE1                ;data bank to $E1
0872 5A39 CE B1 0F              DEC   |retry
0873 5A3C D0 07                 BNE   spile2
0874 5A3E CE B3 0F              DEC   |retry2
0875 5A41 10 02                 BPL   spile2
0876 5A43 AB                    PLB                            ;restore data bank
0877 5A44 60           SPILOUT  RTS   
0878 5A45 AB           SPILE2   PLB                            ;restore data bank
0879 5A46 80 D0                 BRA   spile1                   ;and retry
0880 5A48              *
0881 5A48              RECPACK  EQU   *
0882 5A48 A9 05                 LDA   #<RC2
0883 5A4A 8F B1 0F E1           STA   >Retry
0884 5A4E              RPK1     EQU   *
0885 5A4E 20 06 58              JSR   ReceivePack
0886 5A51 90 13                 BCC   rpout
0887 5A53 A0 01                 LDY   #1
0888 5A55 20 A2 59              JSR   YMSWait
0889 5A58 20 E4 57              JSR   dberror                  ;Recycle handshake and set carry
0890 5A5B AF B1 0F E1           LDA   >retry
0891 5A5F 3A                    DEC   a
0892 5A60 8F B1 0F E1           STA   >retry
0893 5A64 D0 E8                 BNE   rpk1                     ;Carry set still
0894 5A66              RPOUT    EQU   *
0895 5A66 60                    RTS   
0896 5A67              *
0897 5A67              *
0898 5A67                       TITLE 'Divide by 7 routine'
0899 5A67              ************************************************************
0900 5A67              *                                                          *
0901 5A67              *  Divide7                Do DIV and MOD 7 and set auxptr  *
0902 5A67              *                                                          *
0903 5A67              *   This routine divides the bytecount by seven.  The      *
0904 5A67              *  quotient gives the number of groups of seven bytes to   *
0905 5A67              *  be sent, and the remainder gives the number of "odd"    *
0906 5A67              *  bytes.                                                  *
0907 5A67              *                                                          *
0908 5A67              *  Input:   bytecountl,h <- # of bytes to write            *
0909 5A67              *           buffer       <- pointer to data                *
0910 5A67              *  Output:  auxptr       <- pointer to speed up csumming   *
0911 5A67              *           oddbytes     <- bytecount MOD 7                *
0912 5A67              *           grp7ctr      <- bytecount DIV 7                *
0913 5A67              *                                                          *
0914 5A67              ************************************************************
0915 5A67              *
0916 5A67              *
0917 5A67 00 24 49     PDIV7TAB DC B:0,36,73
0918 5A6A 00 04 01     PMOD7TAB DC B:0,4,1
0919 5A6D 00 01 02 04  DIV7TAB  DC B:0,1,2,4,9,18
0920 5A73 00 01 02 04  MOD7TAB  DC B:0,1,2,4,1,2
0921 5A79              *
0922 5A79 00 7F FF     AUXPTRINC DC B:0,$7F,$FF
0923 5A7C              *
0924 5A7C              WRITEPREP EQU   *
0925 5A7C              DIVIDE7  EQU   *
0926 5A7C              *
0927 5A7C              * Set up auxptr <- buffer+$80   if $0FF < bytecount < $200
0928 5A7C              *     or auxptr <- buffer+$100  if $1FF < bytecount
0929 5A7C              *
0930 5A7C A6 51                 LDX   bytecounth               ;0, 1 or 2
0931 5A7E F0 17                 BEQ   noauxptr                 ;Auxptr used only for full pages
0932 5A80              *
0933 5A80 A5 58                 LDA   buffer+1
0934 5A82 85 5C                 STA   auxptr+1                 ;Copy over hi order part
0935 5A84              *
0936 5A84 A9 80                 LDA   #$80                     ;Anticipate smaller bytecount
0937 5A86 E0 01                 CPX   #1                       ;Check bytecount
0938 5A88 F0 04                 BEQ   sap1                     ;=> $0FF < bytecount < $200
0939 5A8A              *
0940 5A8A E6 5C                 INC   auxptr+1                 ;Add $100 to bytecount instead
0941 5A8C A9 00                 LDA   #0                       ;Make sure lo order unaltered
0942 5A8E 18           SAP1     CLC   
0943 5A8F 65 57                 ADC   buffer
0944 5A91 85 5B                 STA   auxptr
0945 5A93 90 02                 BCC   noauxptr
0946 5A95 E6 5C                 INC   auxptr+1
0947 5A97              *
0948 5A97              * Now look up the first order guess for DIV and MOD.  X still has
0949 5A97              *  bytecount DIV 256.
0950 5A97              *
0951 5A97              NOAUXPTR EQU   *
0952 5A97 BD 67 5A              LDA   pdiv7tab,x
0953 5A9A 85 4E                 STA   grp7ctr
0954 5A9C BD 6A 5A              LDA   pmod7tab,x
0955 5A9F 85 4F                 STA   oddbytes
0956 5AA1              *
0957 5AA1              * Now add in the mods and divs for each of the five hi order
0958 5AA1              *  bits in the lo order bytecount, correcting each time MOD becomes
0959 5AA1              *  bigger than 6.
0960 5AA1              *
0961 5AA1 A2 05                 LDX   #5                       ;Do for five bits
0962 5AA3 A5 50                 LDA   bytecountl
0963 5AA5 85 5F                 STA   temp                     ;Store lo order for shifting
0964 5AA7 29 07                 AND   #%00000111               ;Save lo three for later
0965 5AA9 A8                    TAY   
0966 5AAA              *
0967 5AAA              DIVIDE3  EQU   *
0968 5AAA 06 5F                 ASL   temp                     ;C <- next from bytecountl
0969 5AAC 90 15                 BCC   divide2                  ;If clear, no effect on DIV,MOD
0970 5AAE BD 73 5A              LDA   mod7tab,x                ;Get MOD7 for 2^n
0971 5AB1              DIVIDE4  EQU   *
0972 5AB1 18                    CLC   
0973 5AB2 65 4F                 ADC   oddbytes                 ;Got new MOD value
0974 5AB4 C9 07                 CMP   #7                       ;Is it too big?
0975 5AB6 90 02                 BLT   divide1                  ;=> NO leave MOD - 0->C
0976 5AB8 E9 07                 SBC   #7                       ;Bring MOD under 7 - C still set
0977 5ABA              DIVIDE1  EQU   *
0978 5ABA 85 4F                 STA   oddbytes
0979 5ABC BD 6D 5A              LDA   div7tab,x                ;Get DIV for this 2^n
0980 5ABF 65 4E                 ADC   grp7ctr                  ;Add to DIV along with correction (C)
0981 5AC1 85 4E                 STA   grp7ctr                  ;Update the DIV
0982 5AC3              DIVIDE2  EQU   *
0983 5AC3 CA                    DEX                            ;One less bit to deal with
0984 5AC4 30 06                 BMI   divide5                  ;Escape after 6 times through loop
0985 5AC6 D0 E2                 BNE   divide3                  ;Take brnch 1st 5 loops
0986 5AC8              *
0987 5AC8 98                    TYA                            ;Get back the last three bits
0988 5AC9 4C B1 5A              JMP   divide4                  ;Sixth pass add in remains
0989 5ACC              *
0990 5ACC              DIVIDE5  EQU   *
0991 5ACC              *
0992 5ACC              *
0993 5ACC                       TITLE 'Checksum Prepass'
0994 5ACC              **************************************************************
0995 5ACC              *                                                            *
0996 5ACC              *  PreCheck                    Does the checksumming prepass *
0997 5ACC              *                                                            *
0998 5ACC              *   Input:   bytecount   <- bytes in buffer                  *
0999 5ACC              *            buffer      <- pointer to data to send          *
1000 5ACC              *            auxptr      <- extra pointer to speed process   *
1001 5ACC              *   Output:  checksum    <- 8 bit XOR of data to be sent     *
1002 5ACC              *                                                            *
1003 5ACC              **************************************************************
1004 5ACC              *
1005 5ACC              PRECHECK EQU   *
1006 5ACC              *
1007 5ACC              * Checksum any full pages
1008 5ACC              *
1009 5ACC A5 58                 LDA   buffer+1
1010 5ACE 48                    PHA                            ;Preserve buffer pointer
1011 5ACF A9 00                 LDA   #0
1012 5AD1 A6 51                 LDX   bytecounth
1013 5AD3 F0 16                 BEQ   lastpass                 ;If no complete pages, skip this
1014 5AD5              XOR2     EQU   *
1015 5AD5 BC 79 5A              LDY   |auxptrinc,x             ;Get number of bytes each ptr
1016 5AD8              XOR1     EQU   *
1017 5AD8 57 57                 EOR   [buffer],y
1018 5ADA 57 5B                 EOR   [auxptr],y
1019 5ADC 88                    DEY                            ;One less
1020 5ADD D0 F9                 BNE   xor1
1021 5ADF 57 57                 EOR   [buffer],y
1022 5AE1 57 5B                 EOR   [auxptr],y               ;Have to deal with 0 case
1023 5AE3              *
1024 5AE3              * Now move the buffer up for next section
1025 5AE3              *
1026 5AE3 E0 01                 CPX   #1
1027 5AE5 F0 02                 BEQ   xor5                     ;If 256 and up bytes, bump x1
1028 5AE7 E6 58                 INC   buffer+1                 ; otherwise x2
1029 5AE9 E6 58        XOR5     INC   buffer+1
1030 5AEB              *
1031 5AEB              LASTPASS EQU   *
1032 5AEB              *
1033 5AEB              * Do the remaining less than a page with a single pointer
1034 5AEB              *
1035 5AEB A4 50                 LDY   bytecount
1036 5AED F0 09                 BEQ   xor4
1037 5AEF 57 57                 EOR   [buffer],y               ;Compensate for nth byte
1038 5AF1 57 57        XOR3     EOR   [buffer],y
1039 5AF3 88                    DEY   
1040 5AF4 D0 FB                 BNE   xor3
1041 5AF6 57 57                 EOR   [buffer],y               ;Last damn (0th) byte
1042 5AF8              *
1043 5AF8              * Store result away.  Retrieve old buffer value.
1044 5AF8              *
1045 5AF8              XOR4     EQU   *
1046 5AF8 85 40                 STA   checksum
1047 5AFA 68                    PLA   
1048 5AFB 85 58                 STA   buffer+1
1049 5AFD              *
1050 5AFD              *
1051 5AFD                       TITLE 'Get topbits byte for odds'
1052 5AFD              *******************************************************
1053 5AFD              *                                                     *
1054 5AFD              * DetTopBits               Get topbits for odd bytes  *
1055 5AFD              *                                                     *
1056 5AFD              *   Also sets buffer2 pointer to pointer at groups of *
1057 5AFD              *  seven bytes.                                       *
1058 5AFD              *                                                     *
1059 5AFD              *  Input:   oddbytes <- # of "odd" bytes              *
1060 5AFD              *           buffer   <- pointer to data               *
1061 5AFD              *  Output:  tbodd    <- topbits for odd bytes         *
1062 5AFD              *           buffer2  <- buffer+oddbytes               *
1063 5AFD              *                                                     *
1064 5AFD              *******************************************************
1065 5AFD              *
1066 5AFD              DETTOPBITS EQU   *
1067 5AFD              *
1068 5AFD A4 4F                 LDY   oddbytes
1069 5AFF 88                    DEY   
1070 5B00 A9 00                 LDA   #0
1071 5B02 85 5F                 STA   tbodd
1072 5B04              *
1073 5B04 B7 57        GTBOB    LDA   [buffer],y
1074 5B06 0A                    ASL   a
1075 5B07 66 5F                 ROR   tbodd
1076 5B09 88                    DEY   
1077 5B0A 10 F8                 BPL   gtbob
1078 5B0C 38                    SEC   
1079 5B0D 66 5F                 ROR   tbodd
1080 5B0F              *
1081 5B0F A5 4F                 LDA   oddbytes
1082 5B11 18                    CLC   
1083 5B12 65 57                 ADC   buffer
1084 5B14 85 5B                 STA   buffer2
1085 5B16 A5 58                 LDA   buffer+1
1086 5B18 69 00                 ADC   #0
1087 5B1A 85 5C                 STA   buffer2+1
1088 5B1C A5 59                 LDA   buffer+2
1089 5B1E 69 00                 ADC   #0
1090 5B20 85 5D                 STA   buffer2+2
1091 5B22 A5 5A                 LDA   buffer+3
1092 5B24 69 00                 ADC   #0
1093 5B26 85 5E                 STA   buffer2+3
1094 5B28              *
1095 5B28              *
1096 5B28                       TITLE 'Prime write pump'
1097 5B28              **********************************************************
1098 5B28              *                                                        *
1099 5B28              *  Sun                   Set up next buffer and topbits  *
1100 5B28              *                                                        *
1101 5B28              *   Primes the pipe for the group of seven bytes routine *
1102 5B28              *  setting the topbits byte and the "next" buffer.       *
1103 5B28              *  The routine also advances the buffer pointer by 7 to  *
1104 5B28              *  prepare for the groups of seven transfer.             *
1105 5B28              *                                                        *
1106 5B28              *    Input:   buffer2   <- points to groups of 7 data    *
1107 5B28              *    Output:  next1,7   <- first 7 bytes in buffer       *
1108 5B28              *             topbits   <- MSBs of first 7 bytes         *
1109 5B28              *                                                        *
1110 5B28              **********************************************************
1111 5B28              *
1112 5B28              SUN      EQU   *
1113 5B28              *
1114 5B28              * Copy first seven bytes into the pipeline
1115 5B28              *
1116 5B28 20 26 60              JSR   setbank0                 ;data bank to $00
1117 5B2B A0 06                 LDY   #6
1118 5B2D 38           SUN2     SEC   
1119 5B2E B7 5B                 LDA   [buffer2],y
1120 5B30 99 50 00              STA   |next,y
1121 5B33 30 01                 BMI   sun1
1122 5B35 18                    CLC   
1123 5B36 66 41        SUN1     ROR   topbits
1124 5B38 88                    DEY   
1125 5B39 10 F2                 BPL   sun2
1126 5B3B 4B                    PHK                            ;data bank to $FF
1127 5B3C AB                    PLB   
1128 5B3D 38                    SEC   
1129 5B3E 66 41                 ROR   topbits
1130 5B40              *
1131 5B40              * Advance the pointer
1132 5B40              *
1133 5B40 A5 5B                 LDA   buffer2
1134 5B42 18                    CLC   
1135 5B43 69 07                 ADC   #7
1136 5B45 85 5B                 STA   buffer2
1137 5B47 90 02                 BCC   sun3
1138 5B49 E6 5C                 INC   buffer2+1
1139 5B4B              SUN3     EQU   *
1140 5B4B 60                    RTS   
1141 5B4C              *
1142 5B4C              *
1143 5B4C                       TITLE 'Set the IWM mode reg'
1144 5B4C              *
1145 5B4C              * X is slot*16, Y is the desired mode
1146 5B4C              *
1147 5B4C              * Set up the IWM mode register.  Extreme care should be taken
1148 5B4C              *  here. Setting the mode byte with indexed stores causes a false
1149 5B4C              *  byte to be written a cycle before the real value is written.
1150 5B4C              *  This false value, if it enables the timer, causes the IWM Rev A to
1151 5B4C              *  pop the motor on, inhibiting the setting of the mode until the
1152 5B4C              *  motor times out! We avoid this by setting the mode byte only when
1153 5B4C              *  it is not what we want, and if it's not we stay here until we
1154 5B4C              *  see that it is what we want.
1155 5B4C              *
1156 5B4C              SETIWMODE EQU   *
1157 5B4C 20 2B 60              JSR   SetBankE1                ;data bank to $E1
1158 5B4F AD E8 C0              LDA   |monclr+$60              ;Motor must be off
1159 5B52 AD ED C0              LDA   |l6set+$60               ;Set up to access mode register
1160 5B55 80 04                 BRA   careful                  ;Don't mess unless we gotta
1161 5B57 98           BIZ      TYA   
1162 5B58 8D EF C0              STA   |l7set+$60               ;Try storing the mode value
1163 5B5B              CAREFUL  EQU   *
1164 5B5B 98                    TYA                            ;Get back the target value
1165 5B5C 4D EE C0              EOR   |l7clr+$60               ;Compare with observed value
1166 5B5F 29 1F                 AND   #$1F                     ;Can only read low 5 bits
1167 5B61 D0 F4                 BNE   biz                      ;If not right, back to try again
1168 5B63 4B                    PHK                            ;data bank to $FF
1169 5B64 AB                    PLB   
1170 5B65 60                    RTS   
1171 5B66              *
1172 5B66              *
1173 5B66              WAITIWMOFF EQU   *
1174 5B66              *
1175 5B66              * Make sure you're in read mode and wait 'til Disk // motor is off
1176 5B66              *
1177 5B66 A2 60                 LDX   #$60                     ;Set X
1178 5B68 20 2B 60              JSR   SetBankE1                ;data bank to $E1
1179 5B6B BD 8E C0              LDA   |l7clr,x
1180 5B6E BD 8D C0              LDA   |l6set,x
1181 5B71              WIWM1    EQU   *
1182 5B71 BD 8E C0              LDA   |l7clr,x
1183 5B74 29 20                 AND   #%00100000
1184 5B76 D0 F9                 BNE   wiwm1
1185 5B78 BD 8C C0              LDA   |l6clr,x
1186 5B7B              *
1187 5B7B              * Wait an additional 700 microseconds to allow 12V on Disk // to decay
1188 5B7B              *
1189 5B7B 5A                    PHY   
1190 5B7C A0 D9                 LDY   #217
1191 5B7E 88           WIWM2    DEY   
1192 5B7F 80 00                 BRA   *+2
1193 5B81 80 00                 BRA   *+2
1194 5B83 80 00                 BRA   *+2
1195 5B85 D0 F7                 BNE   wiwm2
1196 5B87 7A                    PLY   
1197 5B88              *
1198 5B88 4B                    PHK                            ;data bank to $FF
1199 5B89 AB                    PLB   
1200 5B8A 60                    RTS   
1201 5B8B              *
1202 5B8B              *
1203 5B8B              * This takes grp7ctr and oddbytes and calculates 7*grp7ctr+oddbytes.
1204 5B8B              *  The results are in Y(hi) and A(lo).  This is the number of bytes
1205 5B8B              *  that were received in the last ReceivePack.
1206 5B8B              *
1207 5B8B              RCVCOUNT EQU   *
1208 5B8B A5 4E                 LDA   grp7ctr
1209 5B8D A8                    TAY   
1210 5B8E A2 00                 LDX   #0
1211 5B90 86 4E                 STX   grp7ctr
1212 5B92 A2 03                 LDX   #3
1213 5B94 0A           TIMES7   ASL   a
1214 5B95 26 4E                 ROL   grp7ctr
1215 5B97 CA                    DEX   
1216 5B98 D0 FA                 BNE   times7
1217 5B9A 18                    CLC   
1218 5B9B 65 4F                 ADC   oddbytes
1219 5B9D 90 02                 BCC   t71
1220 5B9F E6 4E                 INC   grp7ctr
1221 5BA1 84 4F        T71      STY   oddbytes
1222 5BA3 38                    SEC   
1223 5BA4 E5 4F                 SBC   oddbytes
1224 5BA6 B0 02                 BCS   t72
1225 5BA8 C6 4E                 DEC   grp7ctr
1226 5BAA A4 4E        T72      LDY   grp7ctr
1227 5BAC 60                    RTS   
1228 5BAD              *
1229 5BAD              *
1230 5BAD                       TITLE 'SmartPort / SmartPort Bus Driver'
1231 5BAD
1232 5BAD              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
1233 5BAD              ;	by EdAsmCvtIIGS version 1.2d7 on 5/16/91 at 1:25:19 PM
1234 5BAD
1235 5BAD              ***********************************
1236 5BAD              * SMART PORT ENTRY POINT
1237 5BAD              ENTRY    EQU   *
1238 5BAD 4B                    PHK                            ;set data bank $FF
1239 5BAE AB                    PLB   
1240 5BAF 90 03                 BCC   bentry                   ;If non-boot, skip jump to boot
1241 5BB1 4C C5 60              JMP   bootcode
1242 5BB4              *
1243 5BB4              * X is still set to slot number.
1244 5BB4              *
1245 5BB4              BENTRY   EQU   *
1246 5BB4 D8                    CLD                            ;Don't want decimal mode!!
1247 5BB5              *
1248 5BB5              * We can't really tolerate interrupts in most of the code, so disable
1249 5BB5 08                    PHP                            ;Save interrupt status
1250 5BB6 A3 01                 LDA   1,s
1251 5BB8 8F C9 0F E1           STA   >IntEnbl
1252 5BBC 78                    SEI                            ;No interrupts please
1253 5BBD              *
1254 5BBD              * Preserve the zero page work area
1255 5BBD              *
1256 5BBD 20 31 60              JSR   SavSysZP                 ;save zpg & set slot 5/6 internal
1257 5BC0 4B                    PHK   
1258 5BC1 AB                    PLB                            ;restore to code bank
1259 5BC2              *
1260 5BC2              * If this is a SP call, then get the address of the parm table
1261 5BC2              * Stack looks like:
1262 5BC2              *      _____________________
1263 5BC2              *  + 9|___PCH-1_____________|--User Call
1264 5BC2              *  + 8|___PCL-1_____________|   ___ ___ ___ ___ ___ ___ ___ ___
1265 5BC2              *  + 7|___ENTRY___FLAG______|--|_7_|_6_|_5_|_4_|_3_|_2_|_1_|_0_|
1266 5BC2              *  + 6|___USER_DATA_BANK____|    |   |    
1267 5BC2              *  + 5|___USER_CYA_REG______|    |   |___ 1 = Boot
1268 5BC2              *  + 4|___PROGRAM_BANK______|    |_______ 1 = ProDOS, 0 = SmartPort
1269 5BC2              *  + 3|___PCH-1_____________|
1270 5BC2              *  + 2|___PCL-1_____________|
1271 5BC2              *  + 1|___Psw_______________|
1272 5BC2              * SP->|_____________________|
1273 5BC2              *
1274 5BC2              *
1275 5BC2 64 59                 STZ   buffer+2
1276 5BC4 AF B0 0F E1           LDA   >ProFlag                 ;ProFLAG[7] 1=ProDOS, 0=SmartPort
1277 5BC8 30 1F                 BMI   noplay                   ;if ProDOS call
1278 5BCA              *
1279 5BCA C2 30                 REP   #$30                     ;16 bit 'm' and 'x'
1280 5BCC                       LONGI ON
1281 5BCC                       LONGA ON
1282 5BCC A3 08                 LDA   8,s                      ;get command addr
1283 5BCE 8F B4 0F E1           STA   >SHTempX                 ;save it
1284 5BD2 85 57                 STA   buffer                   ;get a pointer to retrieve cmd byte
1285 5BD4 A7 57                 LDA   [buffer]                 ;get two bytes (cmd = upper)
1286 5BD6 A0 03 00              LDY   #0003
1287 5BD9 29 00 40              AND   #$4000                   ;test for extended SmartPort cmd
1288 5BDC F0 03                 BEQ   @10                      ;its standard SP
1289 5BDE A0 05 00              LDY   #0005                    ;its extended (I am so privileged)
1290 5BE1 98           @10      TYA   
1291 5BE2 18                    CLC                            ;if nonextended, adjust by 3
1292 5BE3 63 08                 ADC   8,s                      ;adjust return address
1293 5BE5 83 08                 STA   8,s                      ;boy, was that ever wierd!!!
1294 5BE7 E2 30                 SEP   #$30                     ;8 bit 'm' and 'x'
1295 5BE9                       LONGI OFF
1296 5BE9                       LONGA OFF
1297 5BE9              *
1298 5BE9              NOPLAY   EQU   *
1299 5BE9              *
1300 5BE9              * On the //GS, it is important to have the Disk // enable lines
1301 5BE9              * off for as long as possible before using the IWM (phases, /WRREQ
1302 5BE9              * lines).  Wait here 'til the Disk // motors are off.
1303 5BE9              *
1304 5BE9 20 66 5B              JSR   WaitIWMOff               ;Must preserve Y!!
1305 5BEC              *
1306 5BEC              * Now test for a forced INIT from boot code
1307 5BEC AF B6 0F E1           LDA   >Power1
1308 5BF0 49 FF                 EOR   #$FF
1309 5BF2 CF B7 0F E1           CMP   >Power2
1310 5BF6 F0 05                 BEQ   @05
1311 5BF8 A9 40                 LDA   #ColdReset
1312 5BFA 20 03 5F              JSR   AssignID                 ;Reset Device assign before boot
1313 5BFD              *
1314 5BFD              * Now map any ProDOS unit references to our sequential ones.
1315 5BFD              * The method is bizzare and magicians never reveal their secrets.
1316 5BFD              *
1317 5BFD AF B0 0F E1  @05      LDA   >ProFlag                 ;[7]=1 if ProDOS, 0 if SmartPort
1318 5C01 10 22                 BPL   SP1                      ; If it is a SmartPort call.
1319 5C03 A2 05                 LDX   #5
1320 5C05              @10      EQU   *
1321 5C05 B5 42                 LDA   ExtBuff,x                ;move ProDOS parameters
1322 5C07 95 45                 STA   CMDCode,x
1323 5C09 CA                    DEX   
1324 5C0A 10 F9                 BPL   @10
1325 5C0C 64 4B                 STZ   CMDBlocks
1326 5C0E 64 4C                 STZ   CMDSpare1
1327 5C10 64 4D                 STZ   CMDSpare2
1328 5C12 A5 46                 LDA   CMDUnit                  ;76543210 7&6 specify unit
1329 5C14 2A                    ROL   a                        ;6543210X C<-7
1330 5C15 08                    PHP                            ;Save drive num
1331 5C16 2A                    ROL   a                        ;543210X7 C<-6
1332 5C17 2A                    ROL   a                        ;43210X76 (6 is grp of 2)
1333 5C18 28                    PLP                            ;C<-7
1334 5C19 2A                    ROL   a                        ;3210X767
1335 5C1A 29 03                 AND   #%00000011               ;ProDOS only installs up to 4
1336 5C1C 49 02                 EOR   #%00000010               ;000000/67; 6 was /grpoftwo
1337 5C1E AA                    TAX   
1338 5C1F E8                    INX   
1339 5C20 86 46                 STX   CMDUnit                  ;ProDOS unit now a SP unit
1340 5C22 82 DC 00     SKIPC1   BRL   skipcopy
1341 5C25              *
1342 5C25              * For SmartPort calls
1343 5C25              * pull out the command code, and the address of the parameters.
1344 5C25              SP1      EQU   *
1345 5C25 A0 01                 LDY   #1                       ; Stacked address is EA-1
1346 5C27 B7 57                 LDA   [buffer],y
1347 5C29 85 45                 STA   cmdcode                  ; COMMAND after JSR to SP
1348 5C2B C8                    INY   
1349 5C2C C2 30                 REP   #$30                     ; 16 bit 'm' and 'x'
1350 5C2E B7 57                 LDA   [buffer],y               ; Get parmlist address
1351 5C30 AA                    TAX                            ; Save it
1352 5C31 E2 20                 SEP   #$20                     ; 8 bit 'm'
1353 5C33 24 45                 BIT   CMDCode                  ; is it an extended call?
1354 5C35 50 08                 BVC   NonExtPL                 ; no
1355 5C37 C2 20                 REP   #$20                     ; 16 bit 'm'
1356 5C39 C8                    INY   
1357 5C3A C8                    INY   
1358 5C3B B7 57                 LDA   [buffer],y               ; Get hi part
1359 5C3D 85 59                 STA   buffer+2
1360 5C3F 86 57        NONEXTPL STX   buffer
1361 5C41 E2 30                 SEP   #$30                     ; 8 bit 'm' and 'x'
1362 5C43              *
1363 5C43              * Now buffer points to parmlist
1364 5C43              *  Check command type, and pidgeonhole the parmlist length
1365 5C43              *
1366 5C43 A5 45                 LDA   CMDCode                  ;check if short list
1367 5C45 29 BF                 AND   #%10111111               ;but mask extension
1368 5C47 AA                    TAX   
1369 5C48 A9 01        ERRBADC  LDA   #BadCmd
1370 5C4A E0 0D                 CPX   #SPcmdcnt                ;Only valid codes are 0-D
1371 5C4C 90 03                 BLT   noeh                     ;=> at least he got that right
1372 5C4E 4C 67 5E     ERRORHITCH JMP   Error                  ;Gee, maybe we should promote this guy...
1373 5C51              NOEH     EQU   *
1374 5C51 A0 00                 LDY   #0                       ;Set for indct compare
1375 5C53 B7 57                 LDA   [buffer],y               ;Get # of parms?
1376 5C55 85 60                 STA   Unit
1377 5C57 C8                    INY   
1378 5C58 B7 57                 LDA   [buffer],y               ;get the unit #
1379 5C5A 85 46                 STA   CMDUnit
1380 5C5C              *
1381 5C5C              * Now copy the bytes
1382 5C5C              *
1383 5C5C              OKAYCNT  EQU   *
1384 5C5C C2 20                 REP   #$20                     ;16 bit 'm'
1385 5C5E A5 45                 LDA   CMDCode                  ;move command/unit until have parms
1386 5C60 85 42                 STA   ExtBuff
1387 5C62 E2 20                 SEP   #$20                     ;8 bit 'm'
1388 5C64 A2 0B                 LDX   #<EPlength-1             ;stuff like an extended
1389 5C66 A0 0B                 LDY   #<EPlength-1             ;assume an extended
1390 5C68 70 02                 BVS   copyloop                 ;hey, we assumed right!
1391 5C6A A0 08                 LDY   #<Plength-1              ;Always copy the maximum
1392 5C6C              COPYLOOP EQU   *
1393 5C6C B7 57                 LDA   [buffer],y               ;Pull it out of their hat
1394 5C6E 95 42                 STA   ExtBuff,x                ;Stuff it into mine
1395 5C70 CA                    DEX   
1396 5C71 88                    DEY   
1397 5C72 C0 01                 CPY   #1                       ;but the unit # is already done
1398 5C74 D0 F6                 BNE   copyloop                 ;Copy 'em all
1399 5C76 50 10                 BVC   NoMash                   ;don't mash parm if nonext
1400 5C78 C2 30                 REP   #$30                     ;now restore list order
1401 5C7A A6 42                 LDX   ExtBuff                  ;get command/unit
1402 5C7C A5 44                 LDA   CMDCode-1                ;get ext bufflow
1403 5C7E 85 42                 STA   ExtBuff                  ;set'em up right
1404 5C80 A5 45                 LDA   CMDCode
1405 5C82 85 43                 STA   ExtBuff+1
1406 5C84 86 45                 STX   CMDCode                  ;restore command/unit
1407 5C86 E2 30                 SEP   #$30                     ;8 bit 'm' and 'x'
1408 5C88              NOMASH   EQU   *
1409 5C88 4B                    PHK                            ;data bank to $FF
1410 5C89 AB                    PLB   
1411 5C8A              *
1412 5C8A              * Okay.  The caller of the SP could be making one of three calls
1413 5C8A              * with a unit number of $00, Control, Init or Status.  Check for these
1414 5C8A              * and do what is appropriate.
1415 5C8A              *
1416 5C8A A5 45                 LDA   CMDCode                  ;remove ext bit from cmdCode
1417 5C8C 29 BF                 AND   #%10111111
1418 5C8E AA                    TAX                            ;and put it in x reg
1419 5C8F A5 46                 LDA   CMDUnit
1420 5C91 F0 0B                 BEQ   @10                      ;it is unit zero
1421 5C93 C9 7F                 CMP   #$7F                     ;max unit is $7E as per spec's
1422 5C95 B0 04                 BCS   @08
1423 5C97 E0 05                 CPX   #InitCmd                 ;INITcmd for non zero unit???
1424 5C99 D0 87                 BNE   skipc1
1425 5C9B 82 5B 00     @08      BRL   BUnit
1426 5C9E 24 45        @10      BIT   CMDCode                  ; is it an extended command ?
1427 5CA0 70 03                 BVS   @20                      ; yes, then dont restructure
1428 5CA2 20 AB 5E              JSR   NONtoEXT                 ; no, then restructure
1429 5CA5              *
1430 5CA5              * Check the parameter count for this call to unit#0
1431 5CA5              *
1432 5CA5              @20      EQU   *
1433 5CA5 BF 9B C5 00           LDA   >parmctab,x              ;Get the length this command
1434 5CA9 29 7F                 AND   #$7F                     ;Force 0 -> MSB
1435 5CAB A8                    TAY                            ;Hang on
1436 5CAC A9 04                 LDA   #BadPCnt                 ;Antic bad count
1437 5CAE C4 60                 CPY   Unit                     ;User's pcount is currently here
1438 5CB0 D0 9C                 BNE   ErrorHitch               ;What a baby!
1439 5CB2              *
1440 5CB2              * Now service one of the three commands
1441 5CB2 E0 05                 CPX   #InitCMD
1442 5CB4 D0 10                 BNE   notinit                  ;Not an Init call
1443 5CB6 A9 40                 LDA   #ColdReset               ;almost like pwrup
1444 5CB8 20 03 5F              JSR   AssignID                 ;Do a reset cycle
1445 5CBB A9 00        AOKAY    LDA   #0                       ;No error allowed
1446 5CBD 20 2B 60              JSR   SetBankE1                ; data bank to E1 before exit
1447 5CC0 82 CA 01              BRL   sa2
1448 5CC3              *
1449 5CC3              ERRHITCH EQU   *
1450 5CC3 82 88 FF              BRL   ErrorHitch
1451 5CC6              *
1452 5CC6 8A           NOTINIT  TXA                            ;Equiv to 'cmp #StatusCMD'
1453 5CC7 D0 21                 BNE   maybectrl
1454 5CC9              *
1455 5CC9 A9 21                 LDA   #BadCtl                  ;Antic a non zero stat code
1456 5CCB A6 48                 LDX   CMDSCode                 ;Stat unit#0 can only be code=0
1457 5CCD D0 F4                 BNE   ErrHitch
1458 5CCF              *
1459 5CCF 8A                    TXA                            ;Equiv to 'lda #0'
1460 5CD0 A0 07                 LDY   #7
1461 5CD2 97 42        NIN1     STA   [ExtBuff],y              ;Clear some space
1462 5CD4 88                    DEY   
1463 5CD5 D0 FB                 BNE   nin1
1464 5CD7              *
1465 5CD7 AF B8 0F E1           LDA   >NumDevices
1466 5CDB 97 42                 STA   [ExtBuff],y              ;Stick it where they want it
1467 5CDD C8                    INY   
1468 5CDE              *
1469 5CDE A9 00                 LDA   #0                       ;No interrupts on //GS SmartPort
1470 5CE0 97 42                 STA   [ExtBuff],y              ;Store SP interrupt status
1471 5CE2              *
1472 5CE2 A9 08                 LDA   #8
1473 5CE4 88                    DEY                            ;A,Y has 0008; # bytes status
1474 5CE5 20 1C 60              JSR   squirrel
1475 5CE8              *
1476 5CE8 80 D1                 BRA   Aokay                    ;Skip down (up) with no error
1477 5CEA              MAYBECTRL EQU   *
1478 5CEA C9 04                 CMP   #ControlCMD
1479 5CEC D0 0B                 BNE   BUnit                    ;Unit #0 was a bad one
1480 5CEE              *
1481 5CEE A6 48                 LDX   CMDSCode                 ;We allow two control calls for Unit#0
1482 5CF0 F0 0B                 BEQ   enabint                  ;0 means enable interrupts
1483 5CF2 CA                    DEX   
1484 5CF3 F0 08                 BEQ   disabint                 ;1 means disable interrupts
1485 5CF5 A9 21                 LDA   #badctl
1486 5CF7              ERRORHITCH2 EQU   *
1487 5CF7 D0 CA                 BNE   ErrHitch                 ;No other codes allowed
1488 5CF9              *
1489 5CF9              BUNIT    EQU   *
1490 5CF9 A9 11                 LDA   #badUnit                 ;Only certain calls can have Unit#0
1491 5CFB D0 C6                 BNE   ErrHitch                 ;Branch always
1492 5CFD              *
1493 5CFD              ENABINT  EQU   *
1494 5CFD              DISABINT EQU   *
1495 5CFD A9 1F                 LDA   #NoInt                   ;No interrupt support
1496 5CFF D0 C2                 BNE   ErrHitch
1497 5D01              *
1498 5D01              * Okay, everything's all groovy.  ProDOS re-enters here.
1499 5D01              *  Check Unit number to be sure there is a corresponding device
1500 5D01              SKIPCOPY EQU   *
1501 5D01 AF B8 0F E1           LDA   >NumDevices
1502 5D05 AA                    TAX   
1503 5D06 A9 28                 LDA   #NoDrive                 ;Anticpate bad unit number
1504 5D08 E4 46                 CPX   CMDUnit
1505 5D0A 90 EB                 BLT   ErrorHitch2              ;Safe- If C clr then Z is clr
1506 5D0C              *
1507 5D0C              * Set buffer and bytecount in anticpation of the inevitable SendPack.
1508 5D0C              RESENDCMD EQU   *
1509 5D0C A9 09                 LDA   #<cmdlength              ;Command packets are 9 bytes long
1510 5D0E 85 50                 STA   bytecountl
1511 5D10 64 51                 STZ   bytecounth
1512 5D12 A9 45                 LDA   #<cmdcode
1513 5D14 85 57                 STA   buffer
1514 5D16 64 58                 STZ   buffer+1
1515 5D18 64 59                 STZ   buffer+2
1516 5D1A 64 5A                 STZ   buffer+3
1517 5D1C              *
1518 5D1C              * If it's a SP call, omit the next two steps
1519 5D1C AF B0 0F E1           LDA   >ProFlag                 ;Is it a call from ProDOS?
1520 5D20 10 12                 BPL   notstat                  ;=> Statcode already set...
1521 5D22              *
1522 5D22              * Need to generate a parameter count for a ProDOS call
1523 5D22 A6 45                 LDX   CMDCode
1524 5D24 BF 9B C5 00           LDA   >ParmCTab,x
1525 5D28 29 7F                 AND   #$7F
1526 5D2A 85 60                 STA   Unit
1527 5D2C              *
1528 5D2C              * If this is a ProDOS status call, set stat code to zero
1529 5D2C A5 45                 LDA   CMDCode                  ;get command
1530 5D2E D0 04                 BNE   notstat                  ;=> Not status so forget it
1531 5D30 85 48                 STA   CMDSCode                 ;Store in command table
1532 5D32 85 49                 STA   CMDSCode+1               ;Store for RAM DISK/AppleDisk3.5
1533 5D34              *
1534 5D34              * Okay, finally direct command to proper driver
1535 5D34              NOTSTAT  EQU   *
1536 5D34 A5 60                 LDA   Unit
1537 5D36 A6 46                 LDX   CmdPCount                ;Swap the Parmcount & unit#
1538 5D38 86 60                 STX   Unit
1539 5D3A 85 46                 STA   CMDPCount                ;Now they're correct
1540 5D3C 8A                    TXA   
1541 5D3D C9 05                 CMP   #5                       ;remap if unit <= 4
1542 5D3F B0 4E                 BGE   SmartBuss                ;if not remap must be smartBuss
1543 5D41 CA                    DEX   
1544 5D42 20 2B 60              JSR   SetBankE1
1545 5D45 BD C0 0F              LDA   |ReMap,x                 ;remap unit #
1546 5D48 85 60                 STA   Unit
1547 5D4A CD BF 0F              CMP   |SmartUnit               ;dispatch to smartbuss driver?
1548 5D4D B0 40                 BGE   SmartBuss                ;yes
1549 5D4F 24 45                 BIT   CMDCode                  ;extended command?
1550 5D51 70 03                 BVS   NoRemap                  ;if it is, leave it alone
1551 5D53 20 AB 5E              JSR   NONtoEXT                 ; convert nonextended to extended
1552 5D56              NOREMAP  EQU   *
1553 5D56 A5 60                 LDA   Unit
1554 5D58 CD BC 0F              CMP   |RamUnit                 ;dispatch to Ram Disk?
1555 5D5B F0 16                 BEQ   RamDsptch                ;yes
1556 5D5D CD BD 0F              CMP   |RomUnit                 ;dispatch to Rom Disk?
1557 5D60 F0 25                 BEQ   RomDsptch                ;yes
1558 5D62 20 AF 60              JSR   StatSet                  ; special case prodos status
1559 5D65 20 00 3C              JSR   |AppleDisk               ; must be AppleDisk3.5
1560 5D68 85 50                 STA   StatByte                 ;save away any error
1561 5D6A 8E B4 0F              STX   |SHTempX                 ;save away xfer count
1562 5D6D 8C B5 0F              STY   |SHTempY
1563 5D70 4C 41 5E     DEXIT    JMP   SonyRet
1564 5D73              RAMDSPTCH EQU   *
1565 5D73 20 AF 60              JSR   StatSet                  ; special case prodos status
1566 5D76 20 B4 61              JSR   RamDisk                  ;off to the Ram Disk driver
1567 5D79 A5 51        RRET     LDA   statbyte+1
1568 5D7B 8F B4 0F E1           STA   >SHTempX                 ; save away xfer count
1569 5D7F A5 52                 LDA   statbyte+2
1570 5D81 8F B5 0F E1           STA   >SHTempY
1571 5D85 80 E9                 BRA   DExit
1572 5D87              ROMDSPTCH EQU   *
1573 5D87 20 AF 60              JSR   StatSet                  ; special case prodos status
1574 5D8A 20 2B 62              JSR   RomDisk                  ;off to the RomDisk driver
1575 5D8D 80 EA                 BRA   RRet
1576 5D8F              SMARTBUSS EQU   *
1577 5D8F A5 45                 LDA   CMDCode                  ;get extended
1578 5D91 29 40                 AND   #%01000000
1579 5D93 09 80                 ORA   #%10000000
1580 5D95 85 61                 STA   WPacketType              ;Packet type bit 6 is extended
1581 5D97              *
1582 5D97 20 D2 59              JSR   ClrPhases                ;Bring all phases off for Quark
1583 5D9A              *
1584 5D9A 20 F5 59              JSR   SendPack
1585 5D9D B0 65                 BCS   behitch                  ;If not okay, skip to bus error
1586 5D9F              *
1587 5D9F              * Now copy over the buffer address for any data xfer.
1588 5D9F C2 20                 REP   #$20                     ;16 bit 'm'
1589 5DA1 A5 47                 LDA   CMDBuffer                ;assume non extended
1590 5DA3 85 57                 STA   buffer
1591 5DA5 64 59                 STZ   Buffer+2
1592 5DA7 E2 20                 SEP   #$20                     ;8 bit 'm'
1593 5DA9 24 45                 BIT   CMDCode                  ;extended?
1594 5DAB 50 13                 BVC   BuffOK                   ;no
1595 5DAD C2 20                 REP   #$20                     ;16 bit 'm'
1596 5DAF A5 42                 LDA   ExtBuff                  ;set up extended buffer
1597 5DB1 85 57                 STA   Buffer
1598 5DB3 E2 20                 SEP   #$20                     ;8 bit 'm'
1599 5DB5 A5 47                 LDA   CMDBuffer
1600 5DB7 EB                    XBA   
1601 5DB8 A5 44                 LDA   ExtBuff+2
1602 5DBA C2 20                 REP   #$20                     ;16 bit 'm'
1603 5DBC 85 59                 STA   Buffer+2
1604 5DBE E2 20                 SEP   #$20                     ;8 bit 'm'
1605 5DC0              BUFFOK   EQU   *
1606 5DC0              *
1607 5DC0              * Now for some commands, we have to send over a packet of data, too.
1608 5DC0              *  See if this command is one of THOSE.
1609 5DC0 A5 45                 LDA   cmdcode
1610 5DC2 29 BF                 AND   #%10111111               ;truncate to non extended
1611 5DC4 AA                    TAX   
1612 5DC5 BD 9B C5              LDA   |parmctab,x
1613 5DC8 10 41                 BPL   noxtrasend               ;Encoded in top bit
1614 5DCA              *
1615 5DCA              * The buffer address and bytecount depend on the call type.
1616 5DCA E0 04                 CPX   #ControlCmd
1617 5DCC D0 1B                 BNE   NOControl
1618 5DCE              *
1619 5DCE              * In the case of control, bytecount:=(buffer) then buffer:=buffer+2
1620 5DCE A0 01                 LDY   #1
1621 5DD0 B7 57                 LDA   [buffer],y               ;Get Hi order bytecount
1622 5DD2 AA                    TAX   
1623 5DD3 88                    DEY   
1624 5DD4 B7 57                 LDA   [buffer],y
1625 5DD6 48                    PHA                            ;Keep for later
1626 5DD7 18                    CLC   
1627 5DD8 A9 02                 LDA   #2
1628 5DDA 65 57                 ADC   buffer
1629 5DDC 85 57                 STA   buffer
1630 5DDE 68                    PLA                            ;Get back Lo order bytecount
1631 5DDF 90 16                 BCC   secondsend               ;Skip hi ord increment
1632 5DE1 C2 20                 REP   #$20                     ;'m' = 16 bits 
1633 5DE3 E6 58                 INC   buffer+1                 ;adjust both bytes of pointer
1634 5DE5 E2 20                 SEP   #$20                     ;'m' = 8 bits
1635 5DE7 80 0E                 BRA   secondsend               ;Skip to store bytecount
1636 5DE9              *
1637 5DE9              NOCONTROL EQU   *
1638 5DE9 E0 02                 CPX   #WriteCMD                ;Check for a writeblock
1639 5DEB D0 06                 BNE   NOWBlock                 ;Must be control or write
1640 5DED              *
1641 5DED              * In the case of WriteBlock, the length is 512 and the buffer
1642 5DED              *  address is at buffer in the command table
1643 5DED A9 00                 LDA   #0
1644 5DEF A2 02                 LDX   #2
1645 5DF1 D0 04                 BNE   secondsend
1646 5DF3              *
1647 5DF3              * For FileWrite, the buffer address is at CMDbuffer
1648 5DF3              *  and the length is at CMDblock.
1649 5DF3              NOWBLOCK EQU   *
1650 5DF3 A6 4A                 LDX   CMDBlockh
1651 5DF5 A5 49                 LDA   CMDBlockl
1652 5DF7              *
1653 5DF7              SECONDSEND EQU   *
1654 5DF7 86 51                 STX   bytecounth
1655 5DF9 85 50                 STA   bytecountl
1656 5DFB              *
1657 5DFB A9 82                 LDA   #datamark
1658 5DFD 85 61                 STA   WPacketType              ;Identify this as a data packet
1659 5DFF              *
1660 5DFF 20 E6 59              JSR   SendData
1661 5E02 90 07                 BCC   noxtrasend
1662 5E04              BEHITCH  EQU   *
1663 5E04 20 2B 60              JSR   SetBankE1                ;data bank to $E1
1664 5E07 A9 06                 LDA   #BusErr                  ;This is the bus error hitch
1665 5E09 D0 5C                 BNE   Error
1666 5E0B              *
1667 5E0B              * On ProDOS status call, we've got to point the buffer pointer
1668 5E0B              *  correctly to zero page... it's the only case special case
1669 5E0B              *  (on Write, Format and Control no data comes back).
1670 5E0B              *
1671 5E0B              NOXTRASEND EQU   *
1672 5E0B AF B0 0F E1           LDA   >ProFlag
1673 5E0F 10 0C                 BPL   getresults
1674 5E11 A5 45                 LDA   cmdcode
1675 5E13 D0 08                 BNE   getresults
1676 5E15              *
1677 5E15 A9 48                 LDA   #<CMDBufferh             ;Want status in these four
1678 5E17 A2 00                 LDX   #>CMDBufferh
1679 5E19 85 57                 STA   buffer
1680 5E1B 86 58                 STX   buffer+1
1681 5E1D              *
1682 5E1D              * Please to be calling ReceivePack
1683 5E1D              *
1684 5E1D              GETRESULTS EQU   *
1685 5E1D 20 48 5A              JSR   RecPack                  ;Get status byte (maybe read data too)
1686 5E20 90 16                 BCC   RxPack1                  ; if no error
1687 5E22 AF CB 0F E1           LDA   >CmdRetry                ; retry command ?
1688 5E26 3A                    DEC   a
1689 5E27 8F CB 0F E1           STA   >CmdRetry
1690 5E2B F0 D7                 BEQ   behitch                  ; no
1691 5E2D A5 60                 LDA   Unit                     ; have to swap back the
1692 5E2F A6 46                 LDX   CmdPCount                ; Unit # and ParmCnt
1693 5E31 86 60                 STX   Unit                     ; before resending the
1694 5E33 85 46                 STA   CmdPCount                ; command packet.
1695 5E35 82 D4 FE              BRL   ReSendCMD                ; now go resend entire command
1696 5E38              *
1697 5E38              * Figure how many bytes were sent and put that in X,Y temps
1698 5E38              *
1699 5E38              RXPACK1  EQU   *
1700 5E38 20 8B 5B              JSR   Rcvcount                 ;Do the times 7...
1701 5E3B 20 1C 60              JSR   squirrel                 ;Store away count in SHTEMPs
1702 5E3E              *
1703 5E3E              * For the ProDOS status call, we've got to look at the status byte
1704 5E3E              *  returned and return a DIP error if appropriate.
1705 5E3E              *  Also overwrite the X,Y temps with # blocks if this is a ProDOS Stat call.
1706 5E3E              *
1707 5E3E 20 2B 60              JSR   SetBankE1                ;data bank to $E1
1708 5E41              SONYRET  EQU   *
1709 5E41 A5 45                 LDA   CMDCode                  ;Is it a ProDOS status call
1710 5E43 D0 20                 BNE   noerror
1711 5E45 AD B0 0F              LDA   |ProFlag
1712 5E48 10 1B                 BPL   noerror
1713 5E4A              *
1714 5E4A A5 49                 LDA   CMDBlockl                ;This'll get loaded into the XY regs later
1715 5E4C 8D B4 0F              STA   |SHTempX
1716 5E4F A5 4A                 LDA   CMDBlockh
1717 5E51 8D B5 0F              STA   |SHTempY
1718 5E54              *
1719 5E54 A5 48                 LDA   CMDBufferh               ;Check status byte
1720 5E56 89 10                 BIT   #%00010000               ;is volume online?
1721 5E58 D0 04                 BNE   @10                      ;yes. go test write protect
1722 5E5A A9 2F                 LDA   #Offline
1723 5E5C 80 09                 BRA   error
1724 5E5E              @10      EQU   *
1725 5E5E 4A                    LSR   a
1726 5E5F 4A                    LSR   a
1727 5E60 4A                    LSR   a
1728 5E61 A9 2B                 LDA   #WriteProt
1729 5E63 B0 02                 BCS   error
1730 5E65              *
1731 5E65              *  Now it's time to think about returning to the caller
1732 5E65              *  Remember that ProDOS doesn't want to know about soft errors,
1733 5E65              *  only fatal ones.  If this is a ProDOS call, and the soft error
1734 5E65              *  bit in the statbyte is set, there IS NO error (statbyte is cleared).
1735 5E65              *  Also, ProDOS wants only I/O, Write Protect, No Device, Offline.
1736 5E65              *  If any other hard error comes from the device on a ProDOS call,
1737 5E65              *  map it to an I/O Error.  (Gross me out.)
1738 5E65              *
1739 5E65              NOERROR  EQU   *
1740 5E65 A5 50                 LDA   statbyte
1741 5E67              ERROR    EQU   *
1742 5E67 20 2B 60              JSR   SetBankE1                ; data bank to $E1
1743 5E6A 8D B1 0F              STA   |Retry                   ;Keep unadulterated error in shole
1744 5E6D AA                    TAX                            ;Set the Z flag
1745 5E6E F0 1D                 BEQ   sa2                      ;Special case the zero
1746 5E70              *
1747 5E70 48                    PHA                            ;save error code
1748 5E71 AD B0 0F              LDA   |ProFlag                 ;ProFLAG[7]=Prodos Call
1749 5E74 2A                    ROL   a                        ;C<6 5 4 3 2 1 0 X
1750 5E75 68                    PLA                            ;restore error code
1751 5E76 90 15                 BCC   sa2                      ;If SP call, no mapping occurs
1752 5E78              *
1753 5E78 A2 00                 LDX   #0                       ;Assume a soft error
1754 5E7A C9 40                 CMP   #%01000000               ;Soft error check
1755 5E7C B0 0E                 BGE   @80                      ;If $40 or bigger, map to zero
1756 5E7E              *
1757 5E7E A2 27                 LDX   #IOError                 ;Now anticipate ProDOS I/O error
1758 5E80 C9 2B                 CMP   #WriteProt
1759 5E82 F0 09                 BEQ   sa2                      ;OK to return Write Protect
1760 5E84 C9 28                 CMP   #NoDrive
1761 5E86 F0 05                 BEQ   sa2                      ;OK to return Drive disconnected
1762 5E88 C9 2F                 CMP   #OffLine
1763 5E8A F0 01                 BEQ   SA2
1764 5E8C              *
1765 5E8C              @80      EQU   *
1766 5E8C 8A                    TXA                            ;Use the default value
1767 5E8D              SA2      EQU   *
1768 5E8D 8D B2 0F              STA   |SHTemp1                 ;Keep in screenhole
1769 5E90 8B                    PHB   
1770 5E91 20 D0 5E              JSR   RestoreIWM               ;set for Disk][
1771 5E94              *
1772 5E94              * Now, restore our zero page area.
1773 5E94 20 63 60              JSR   ResSysZP                 ;restore zero page
1774 5E97              *
1775 5E97              * We're into the stretch!  Restore interrupt mask, load X, Y, and A
1776 5E97              *  and set the carry if the error byte is non-zero.
1777 5E97 AB                    PLB   
1778 5E98 28                    PLP                            ;Restore interrupt flag
1779 5E99 AD B4 0F              LDA   |SHTempx                 ;Get X value
1780 5E9C AA                    TAX   
1781 5E9D AD B2 0F              LDA   |SHTemp1                 ;Grab the error result code
1782 5EA0 48                    PHA   
1783 5EA1 AD B5 0F              LDA   |SHTempy                 ;Pull out the Y value
1784 5EA4 A8                    TAY                            ;No more access to screenholes
1785 5EA5 18                    CLC                            ;Anticipate zero result code
1786 5EA6 68                    PLA                            ;Pull back result code
1787 5EA7 F0 01                 BEQ   @99                      ;Return with carry clear
1788 5EA9 38                    SEC                            ;Some type of error
1789 5EAA              @99      EQU   *
1790 5EAA 6B                    RTL                            ;return to $Cn space
1791 5EAB                       EJECT 
1792 5EAB
1793 5EAB              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
1794 5EAB              ;	by EdAsmCvtIIGS version 1.2d7 on 5/16/91 at 1:26:51 PM
1795 5EAB
1796 5EAB              *
1797 5EAB              * This routine converts the parameter format in zero
1798 5EAB              * page from a non-extended format to an extended format.
1799 5EAB              *
1800 5EAB              * The remapping of parameters is command dependent. Commands
1801 5EAB              * 0 through 7 require different mapping than commands 8 & 9.
1802 5EAB              * Commands 0 through 7 are remapped as follows.....
1803 5EAB              *
1804 5EAB              *         $45 = CmdCode -----> $45 = CmdCode
1805 5EAB              *         $46 = ParmCnt -----> $46 = ParmCnt
1806 5EAB              *         $47 = >Buffer -----> $42 = >Buffer
1807 5EAB              *         $48 = <Buffer -----> $43 = <Buffer
1808 5EAB              *         $49 = >Block  -----> $48 = >Block
1809 5EAB              *         $4A = <Block  -----> $49 = <Block
1810 5EAB              *         $4B = ^Block  -----> $4A = ^Block
1811 5EAB              *                              $44 = 00
1812 5EAB              *                              $47 = 00
1813 5EAB              *                              $4B = 00
1814 5EAB              *                              $4C = 00
1815 5EAB              *                              $4D = 00
1816 5EAB              *
1817 5EAB              * Commands 8 through 9 are remapped as follows.....
1818 5EAB              *
1819 5EAB              *         $45 = CmdCode -----> $45 = CmdCode
1820 5EAB              *         $46 = ParmCnt -----> $46 = ParmCnt
1821 5EAB              *         $47 = >Buffer -----> $42 = >Buffer
1822 5EAB              *         $48 = <Buffer -----> $43 = <Buffer
1823 5EAB              *         $49 = >Count  -----> $48 = >Count
1824 5EAB              *         $4A = <Count  -----> $49 = <Count
1825 5EAB              *         $4B = >Addr   -----> $4A = >Addr 
1826 5EAB              *         $4C = <Addr   -----> $4B = <Addr
1827 5EAB              *         $4D = ^Addr   -----> $4C = ^Addr
1828 5EAB              *                              $44 = 00
1829 5EAB              *                              $47 = 00
1830 5EAB              *                              $4D = 00
1831 5EAB              *
1832 5EAB              NONTOEXT EQU   *
1833 5EAB A5 45                 LDA   CmdCode                  ; is this a read or write call?
1834 5EAD C9 08                 CMP   #8
1835 5EAF B0 04                 BGE   MapExt                   ; yes, do 2nd remapping type.
1836 5EB1 64 4C                 STZ   CmdSpare1                ; zero out bytes 10 & 11 if not read or
1837 5EB3 64 4D                 STZ   CmdSpare2                ; write call
1838 5EB5              MAPEXT   EQU   *
1839 5EB5 C2 20                 REP   #$20                     ;16 bit 'm'
1840 5EB7                       LONGA ON
1841 5EB7 A5 47                 LDA   CMDBuffer                ; map non extended call to extended
1842 5EB9 85 42                 STA   ExtBuff
1843 5EBB A5 49                 LDA   CMDBlock
1844 5EBD 85 48                 STA   ExtBlock
1845 5EBF A5 4B                 LDA   CMDBlocks
1846 5EC1 85 4A                 STA   CMDBlockh
1847 5EC3 A5 4C                 LDA   CMDSpare1
1848 5EC5 85 4B                 STA   CMDBlocks
1849 5EC7 E2 30                 SEP   #$30
1850 5EC9                       LONGA OFF
1851 5EC9 64 47                 STZ   CMDBuffer
1852 5ECB 64 44                 STZ   ExtBuff+2
1853 5ECD 64 4D                 STZ   CMDSpare2
1854 5ECF 60                    RTS   
1855 5ED0                       EJECT 
1856 5ED0              *********************************************************************
1857 5ED0              *  For the Apple//GS, we need to reset the IWM to its
1858 5ED0              *  former disk // state.  This is done by setting the mode register
1859 5ED0              *  to a little known (and less documented) mode which speeds up the
1860 5ED0              *  internal motor timeout.  When the motor enable has timed out, the
1861 5ED0              *  mode can be set back to zero.  This method is necessary because
1862 5ED0              *  if the timer is enabled within the timeout period, the motor on a
1863 5ED0              *  Rev A IWM pops on for the full timeout period (since mode changes
1864 5ED0              *  are disabled when the motor is on.
1865 5ED0              **********************************************************************
1866 5ED0              RESTOREIWM EQU   *
1867 5ED0 20 2B 60              JSR   SetBankE1                ;data bank to $E1
1868 5ED3 AD E8 C0              LDA   |monclr+$60              ;Motor off
1869 5ED6 2C ED C0              BIT   |l6set+$60               ;Into mode reg access mode
1870 5ED9 A9 2B                 LDA   #$2B                     ;This is the magic "speed up" value
1871 5EDB 8D EF C0              STA   |l7set+$60               ;Throw into mode register
1872 5EDE A0 05                 LDY   #5                       ;wait 8 uSec minimum
1873 5EE0 88                    DEY   
1874 5EE1 D0 FD                 BNE   *-1
1875 5EE3              WAITOFF  EQU   *
1876 5EE3 AD EE C0              LDA   |l7clr+$60               ;Wait 'til motor off
1877 5EE6 29 20                 AND   #$20
1878 5EE8 D0 F9                 BNE   waitoff
1879 5EEA A0 00                 LDY   #0                       ;Now set the reg back to $00
1880 5EEC A2 60                 LDX   #$60                     ;IWM's in slot 6
1881 5EEE 20 4C 5B              JSR   SetIWMode
1882 5EF1 20 2B 60              JSR   SetBankE1                ;data bank to $E1
1883 5EF4 AD EC C0              LDA   |l6clr+$60
1884 5EF7 AD E2 C0              LDA   |ca1clr+$60
1885 5EFA AD E6 C0              LDA   |lstrbclr+$60
1886 5EFD AD E8 C0              LDA   |MonClr+$60              ;MSA Phoenix Mod 7/22/85
1887 5F00 4B                    PHK                            ;data bank to $FF
1888 5F01 AB                    PLB   
1889 5F02 60                    RTS   
1890 5F03
1891 5F03                       TITLE 'ID Assignment Cycle'
1892 5F03              ****************************************************************
1893 5F03              *
1894 5F03              * Devices are assigned starting with unit #1
1895 5F03              * in ascending order as follows:
1896 5F03              *
1897 5F03              *   INPUTS:   A = init code 
1898 5F03              *                 $00 = pwron reset
1899 5F03              *                 $40 = INIT cmd or Ctrl-Oapple-Reset
1900 5F03              *                 $80 = Comm Reset (from Cbuss Driver)
1901 5F03              *
1902 5F03              *          RAM DISK
1903 5F03              *          ROM DISK
1904 5F03              *          AppleDisk 3.5
1905 5F03              *          UniDisk 3.5
1906 5F03              *
1907 5F03              ****************************************************************
1908 5F03              ASSIGNID EQU   *
1909 5F03 8F BB 0F E1           STA   >assignflg               ;save assignID mode
1910 5F07
1911 5F07 20 8A 59              JSR   resetchain               ;Reset all of those things
1912 5F0A
1913 5F0A              *
1914 5F0A              * Save the command code, unit, and init code 'cause we'll trample 'em.
1915 5F0A              *
1916 5F0A A5 45                 LDA   CMDCode
1917 5F0C 48                    PHA   
1918 5F0D A5 46                 LDA   CMDPCount
1919 5F0F 48                    PHA   
1920 5F10 A5 48                 LDA   CMDSCode
1921 5F12 48                    PHA   
1922 5F13 A5 60                 LDA   Unit
1923 5F15 48                    PHA   
1924 5F16 AF BB 0F E1           LDA   >assignflg
1925 5F1A 85 48                 STA   CMDScode                 ;store away the type of INIT
1926 5F1C              *
1927 5F1C              * Set up to send DefID command packets
1928 5F1C              *
1929 5F1C A2 05                 LDX   #InitCmd
1930 5F1E 86 45                 STX   CMDCode
1931 5F20 64 60                 STZ   Unit
1932 5F22 A2 02                 LDX   #2                       ;# parms in Init call
1933 5F24 86 46                 STX   CMDPCount
1934 5F26 C9 80                 CMP   #$80                     ; is this a logical device init
1935 5F28 90 08                 BLT   NotLDinit                ;Logical Device init = $80
1936 5F2A AF BF 0F E1           LDA   >SmartUnit               ; if it is, only init UniDisk3.5
1937 5F2E 85 60                 STA   Unit
1938 5F30 80 4F                 BRA   SmartTime
1939 5F32              NOTLDINIT EQU   *
1940 5F32 A9 00                 LDA   #0
1941 5F34 AA                    TAX   
1942 5F35              INITMAP  EQU   *
1943 5F35 9F BC 0F E1           STA   >RamUnit,x
1944 5F39 E8                    INX   
1945 5F3A E0 04                 CPX   #4
1946 5F3C D0 F7                 BNE   InitMap
1947 5F3E              INITMAP0 EQU   *                        ;init ReMap = 01 02 03 04
1948 5F3E 8A                    TXA   
1949 5F3F 9F BF 0F E1           STA   >ReMap-1,x
1950 5F43 CA                    DEX   
1951 5F44 D0 F8                 BNE   InitMap0
1952 5F46
1953 5F46              *
1954 5F46              * Install any RAM DISKs
1955 5F46              *
1956 5F46 E6 60                 INC   Unit                     ; start with unit #1
1957 5F48 20 B4 61              JSR   RamDisk                  ;init Ram Disk
1958 5F4B B0 08                 BCS   RomTime
1959 5F4D A5 60                 LDA   Unit
1960 5F4F 8F BC 0F E1           STA   >RamUnit                 ;Set Ram Disk unit #
1961 5F53 E6 60                 INC   Unit
1962 5F55
1963 5F55              *
1964 5F55              * Install any ROM DISKs
1965 5F55              *
1966 5F55              ROMTIME  EQU   *
1967 5F55 A6 60                 LDX   Unit                     ;x=unit, a=parm count
1968 5F57 A9 01                 LDA   #1
1969 5F59 20 2B 62              JSR   RomDisk                  ;initialize Rom Disk
1970 5F5C B0 08                 BCS   DoDSony
1971 5F5E A5 60                 LDA   Unit
1972 5F60 8F BD 0F E1           STA   >RomUnit                 ;set Rom Disk unit #
1973 5F64 E6 60                 INC   Unit
1974 5F66              *
1975 5F66              * Install any Apple3.5 Disks
1976 5F66              *
1977 5F66              DODSONY  EQU   *
1978 5F66 A9 FF                 LDA   #$FF
1979 5F68 8F B6 0F E1           STA   >power1                  ;force AppleDisk Configure 
1980 5F6C A5 60                 LDA   Unit                     ; get unit #
1981 5F6E 8F BE 0F E1           STA   >DumbUnit
1982 5F72 80 02                 BRA   @20
1983 5F74              @10      EQU   *
1984 5F74 E6 60                 INC   Unit
1985 5F76              @20      EQU   *
1986 5F76 A6 60                 LDX   unit                     ;save away unit #
1987 5F78 DA                    PHX   
1988 5F79 20 00 3C              JSR   |AppleDisk               ;Try to init AppleDisk 3.5
1989 5F7C FA                    PLX                            ;restore unit #
1990 5F7D 86 60                 STX   unit
1991 5F7F 90 F3                 BCC   @10                      ;and check for next AppleDisk 3.5
1992 5F81              @30      EQU   *
1993 5F81
1994 5F81              *
1995 5F81              * Assign ID's to any UniDisk 3.5 - SmartPort devices
1996 5F81              *
1997 5F81              SMARTTIME EQU   *
1998 5F81 A9 45                 LDA   #<CMDCode
1999 5F83 85 57                 STA   buffer
2000 5F85 64 58                 STZ   buffer+1
2001 5F87 64 59                 STZ   buffer+2
2002 5F89 A5 45                 LDA   CMDCode                  ;now build type
2003 5F8B 29 40                 AND   #%01000000
2004 5F8D 09 80                 ORA   #%10000000
2005 5F8F 85 61                 STA   WPacketType              ;encode type with extended bit
2006 5F91              *
2007 5F91 20 D2 59              JSR   ClrPhases                ;Make sure phases are off for Quark
2008 5F94              *
2009 5F94              * Send an ID for the next device in the chain
2010 5F94              *
2011 5F94 A5 60                 LDA   Unit
2012 5F96 8F BF 0F E1           STA   SmartUnit
2013 5F9A 80 02                 BRA   MorDevices
2014 5F9C              MDEV0    EQU   *
2015 5F9C E6 60                 INC   Unit
2016 5F9E              MORDEVICES EQU   *
2017 5F9E A9 09                 LDA   #<cmdlength
2018 5FA0 85 50                 STA   bytecountl               ;ReceivePack scrambles count
2019 5FA2 64 51                 STZ   bytecounth
2020 5FA4              *
2021 5FA4 20 7A 56              JSR   SendOnePack              ;Send the command
2022 5FA7 90 05                 BCC   mdev2                    ;If okay, skip to get response
2023 5FA9              *
2024 5FA9 C6 60                 DEC   Unit
2025 5FAB 4C B5 5F              JMP   mdev1
2026 5FAE              *
2027 5FAE 20 06 58     MDEV2    JSR   ReceivePack              ;Get the response
2028 5FB1 A5 50                 LDA   statbyte
2029 5FB3 F0 E7                 BEQ   mdev0
2030 5FB5              *
2031 5FB5              * Okay, we done last device.  Squirrel away the number of devices.
2032 5FB5              *
2033 5FB5              MDEV1    EQU   *
2034 5FB5 20 2B 60              JSR   SetBankE1                ;data bank to $E1
2035 5FB8 A5 60                 LDA   Unit
2036 5FBA 8D B8 0F              STA   |NumDevices              ;Devices out there
2037 5FBD              *
2038 5FBD              * Recover the scrambled ProDOS parms
2039 5FBD              *
2040 5FBD 68                    PLA   
2041 5FBE 85 60                 STA   unit
2042 5FC0 68                    PLA   
2043 5FC1 85 48                 STA   CMDSCode
2044 5FC3 68                    PLA   
2045 5FC4 85 46                 STA   CMDPCount
2046 5FC6 68                    PLA   
2047 5FC7 85 45                 STA   CMDCode
2048 5FC9              *
2049 5FC9              * Now set the powerup bytes so we'll never have to do this again.
2050 5FC9              *
2051 5FC9 A9 A5                 LDA   #PBBValue
2052 5FCB 8D B6 0F              STA   |Power1
2053 5FCE 49 FF                 EOR   #$FF
2054 5FD0 8D B7 0F              STA   |Power2                  ;set the power up flags
2055 5FD3 AF BB 0F E1           LDA   >assignflg
2056 5FD7 30 42                 BMI   DoneIt                   ;don't remap if it was a CommReset
2057 5FD9                       EJECT 
2058 5FD9              ***************************************************
2059 5FD9              *
2060 5FD9              * Now it's time to do any remapping based on the
2061 5FD9              * control panel selected boot device.
2062 5FD9              *
2063 5FD9              * 5 = disk
2064 5FD9              * 8 = Ram Disk
2065 5FD9              * 9 = Rom Disk
2066 5FD9              *
2067 5FD9              ***************************************************
2068 5FD9 A2 01                 LDX   #1                       ; prepare for no disk units
2069 5FDB AD B8 0F              LDA   |NumDevices              ; is there really a disk drive?
2070 5FDE CD BE 0F              CMP   |DumbUnit
2071 5FE1 B0 03                 BGE   GoMap                    ; yes
2072 5FE3 8E BE 0F              STX   |DumbUnit                ; fake it out
2073 5FE6              GOMAP    EQU   *
2074 5FE6 AD E8 02              LDA   |BramBuffer+$28          ;get startup device
2075 5FE9 8F CA 0F E1           STA   BramFlag                 ;and save in flag
2076 5FED C9 08                 CMP   #8                       ;is it the Ram Disk ?
2077 5FEF F0 11                 BEQ   RRMap                    ;yes
2078 5FF1 C9 09                 CMP   #9                       ;is it the Rom Disk ?
2079 5FF3 F0 0D                 BEQ   RRMap                    ;yes
2080 5FF5 A9 01                 LDA   #1
2081 5FF7 CD BC 0F              CMP   |RamUnit                 ;is ram disk current boot?
2082 5FFA F0 0C                 BEQ   DiskMap                  ;yes
2083 5FFC CD BD 0F              CMP   |RomUnit                 ;is rom disk current boot
2084 5FFF F0 07                 BEQ   DiskMap                  ;yes
2085 6001 60                    RTS   
2086 6002 AA           RRMAP    TAX                            ;get 8 for RAM and 9 for ROM into X
2087 6003 BD B4 0F              LDA   |RamUnit-8,x             ;get RAMUnit or ROMUnit
2088 6006 80 03                 BRA   MapTime                  ;modify map (put zero if no device!)
2089 6008 AD BE 0F     DISKMAP  LDA   |DumbUnit                ;get UniDisk 3.5 unit
2090 600B              *
2091 600B              * A Reg = Boot device unit #
2092 600B              *
2093 600B              MAPTIME  EQU   *
2094 600B 8D C0 0F              STA   |ReMap                   ;Move new Boot unit to boot position
2095 600E AA                    TAX   
2096 600F F0 0A                 BEQ   DoneIt                   ; in case no RAM DISK/ROM DISK
2097 6011 CA                    DEX                            ;now shift the map
2098 6012 F0 07                 BEQ   DoneIt
2099 6014 8A           DOMAP    TXA   
2100 6015 9D C0 0F              STA   |ReMap,x
2101 6018 CA                    DEX   
2102 6019 D0 F9                 BNE   DoMap
2103 601B              DONEIT   EQU   *
2104 601B 60                    RTS   
2105 601C              *
2106 601C              *
2107 601C              SQUIRREL EQU   *
2108 601C 8F B4 0F E1           STA   >SHTempX
2109 6020 98                    TYA   
2110 6021 8F B5 0F E1           STA   >SHTempY
2111 6025 60                    RTS   
2112 6026              ******************************************
2113 6026              * Routines to set the Data Bank
2114 6026              ******************************************
2115 6026 F4 00 00     SETBANK0 PEA   |$0000
2116 6029 80 03                 BRA   SetBank
2117 602B F4 E1 E1     SETBANKE1 PEA   |$E1E1
2118 602E AB           SETBANK  PLB   
2119 602F AB                    PLB   
2120 6030 60                    RTS   
2121 6031                       EJECT 
2122 6031              *********************************************************
2123 6031              * Save System Zero Page
2124 6031              * 
2125 6031              * and Select Slot 6 internal
2126 6031              *
2127 6031              *********************************************************
2128 6031              SAVSYSZP EQU   *
2129 6031 8B                    PHB                            ;preserve data bank
2130 6032 C2 30                 REP   #$30                     ;16 bit m/x
2131 6034                       LONGI ON
2132 6034                       LONGA ON
2133 6034 A9 22 00              LDA   #ZPsize-1                ;bytes to move
2134 6037 A0 E2 14              LDY   #SysSavRam
2135 603A A2 40 00              LDX   #SMART_ZPAGE
2136 603D 54 E1 00              MVN   Bank00,BankE1
2137 6040                       LONGI OFF
2138 6040                       LONGA OFF
2139 6040 E2 30                 SEP   #$30                     ;8 bit m/x
2140 6042 20 2B 60              JSR   SetBankE1
2141 6045 AD 2D C0              LDA   |SltRomSel               ;get slot configuration
2142 6048 8D C6 0F              STA   |SavRomSel               ;save it
2143 604B C2 30                 REP   #$30
2144 604D                       LONGI ON
2145 604D                       LONGA ON
2146 604D A9 06 00              LDA   #0006
2147 6050 22 08 02 E1           JSL   Slot_Arbiter             ;ask for slot 6
2148 6054 8E C7 0F              STX   |SavSltArb               ;save slot config 
2149 6057 E2 30                 SEP   #$30
2150 6059                       LONGI OFF
2151 6059                       LONGA OFF
2152 6059 AD C6 0F              LDA   |SavRomSel
2153 605C 29 BF                 AND   #%10111111               ;set slots 6 internal
2154 605E 8D 2D C0              STA   |SltRomSel
2155 6061 AB           @10      PLB   
2156 6062 60                    RTS   
2157 6063              *********************************************
2158 6063              * Restore Zero Page & Environment
2159 6063              *********************************************
2160 6063              RESSYSZP EQU   *
2161 6063 8B                    PHB                            ;preserve data bank
2162 6064 C2 30                 REP   #$30                     ;16 bit m/x
2163 6066                       LONGI ON
2164 6066                       LONGA ON
2165 6066 A9 22 00              LDA   #ZPsize-1                ;bytes to move
2166 6069 A2 E2 14              LDX   #SysSavRam
2167 606C A0 40 00              LDY   #SMART_ZPAGE
2168 606F 54 00 E1              MVN   BankE1,Bank00
2169 6072              ;
2170 6072 20 2B 60              JSR   SetBankE1
2171 6075 AE C7 0F              LDX   |SavSltArb               ;get original slot config back
2172 6078 A9 00 03              LDA   #$0300
2173 607B 22 08 02 E1           JSL   Slot_Arbiter
2174 607F                       LONGI OFF
2175 607F                       LONGA OFF
2176 607F E2 30                 SEP   #$30                     ;8 bit m/x
2177 6081 AD C6 0F              LDA   |SavRomSel               ;restore Slot Rom Select
2178 6084 8D 2D C0              STA   |SltRomSel
2179 6087 AB           @10      PLB   
2180 6088 60                    RTS   
2181 6089              *******************************************************
2182 6089              * Save FW Zero Page
2183 6089              *******************************************************
2184 6089              SAVFWZP  EQU   *
2185 6089 8B                    PHB                            ;preserve data bank
2186 608A C2 30                 REP   #$30                     ;16 bit m/x
2187 608C                       LONGI ON
2188 608C                       LONGA ON
2189 608C A9 22 00              LDA   #ZPsize-1                ;bytes to move
2190 608F A0 12 15              LDY   #FWSavRam
2191 6092 A2 40 00              LDX   #SMART_ZPAGE
2192 6095 54 E1 00              MVN   Bank00,BankE1
2193 6098                       LONGI OFF
2194 6098                       LONGA OFF
2195 6098 E2 30                 SEP   #$30                     ;8 bit m/x
2196 609A AB                    PLB                            ;restore data bank
2197 609B 60                    RTS   
2198 609C
2199 609C              *******************************
2200 609C              * Restore FW Zero Page
2201 609C              *******************************
2202 609C              RESFWZP  EQU   *
2203 609C 8B                    PHB                            ;preserve data bank
2204 609D C2 30                 REP   #$30                     ;16 bit m/x
2205 609F                       LONGI ON
2206 609F                       LONGA ON
2207 609F A9 22 00              LDA   #ZPsize-1                ;bytes to move
2208 60A2 A2 12 15              LDX   #FWSavRam
2209 60A5 A0 40 00              LDY   #SMART_ZPAGE
2210 60A8 54 00 E1              MVN   BankE1,Bank00
2211 60AB E2 30                 SEP   #$30                     ; 8 bit 'm' and 'x'
2212 60AD                       LONGI OFF
2213 60AD                       LONGA OFF
2214 60AD AB                    PLB   
2215 60AE 60                    RTS   
2216 60AF
2217 60AF
2218 60AF              STATSET  EQU   *
2219 60AF AD B0 0F              LDA   |ProFlag                 ;[7] 1=Prodos, 0=MLI
2220 60B2 10 0C                 BPL   RDGO                     ;don't redirect if SmartPort call
2221 60B4 A5 45                 LDA   cmdcode                  ;is this a status call
2222 60B6 D0 08                 BNE   RDGO                     ;don't redirect if not status
2223 60B8 A9 48                 LDA   #<ExtBlock               ;else redirect buffer output
2224 60BA A2 00                 LDX   #>ExtBlock
2225 60BC 85 42                 STA   ExtBuff
2226 60BE 86 43                 STX   ExtBuff+1
2227 60C0 A6 60        RDGO     LDX   Unit                     ;x=unit, a=ParmCnt
2228 60C2 A5 46                 LDA   CmdPCount
2229 60C4 60                    RTS   
2230 60C5                       TITLE 'Service Boot Request'
2231 60C5              *******************************************
2232 60C5              BOOTCODE EQU   *
2233 60C5              ********************************************
2234 60C5 AF E8 02 E1           LDA   >BramBuffer+$28          ;check boot device
2235 60C9 CF CA 0F E1           CMP   >BramFlag
2236 60CD F0 06                 BEQ   @10
2237 60CF A9 EE                 LDA   #$EE                     ;force AssignID in mainline
2238 60D1 8F B6 0F E1           STA   >Power1                  ;before the ReadBlock executes
2239 60D5              *
2240 60D5 A2 05        @10      LDX   #5                       ;Copy a command table
2241 60D7 BF 65 61 FF  @20      LDA   >boottab,x
2242 60DB 9F 42 00 00           STA   >ExtBuff,x
2243 60DF CA                    DEX   
2244 60E0 10 F5                 BPL   @20
2245 60E2 AF BC 0F E1           LDA   >RAMunit                 ;RamDisk allocated?
2246 60E6 F0 12                 BEQ   @30                      ;no.
2247 60E8 CF C0 0F E1           CMP   >ReMap                   ;is it boot device?
2248 60EC D0 0C                 BNE   @30                      ;no.
2249 60EE AF 4A 16 E1           LDA   >RDFmtFlag               ;is RamDisk formatted Yet?
2250 60F2 30 06                 BMI   @30                      ;yes. leave it alone
2251 60F4 A9 02                 LDA   #02                      ;place a COP opcode at BF00
2252 60F6 8F 00 BF 00           STA   >FormSelect              ;cause a ProDOS format of null RD
2253 60FA              *
2254 60FA              * Now do the read block $0000 from unit zero to $800
2255 60FA 22 B4 5B FF  @30      JSL   >bentry
2256 60FE B0 12                 BCS   booterr                  ;If fail, check loc
2257 6100              *
2258 6100 AF 00 08 00           LDA   >$800                    ;If ($800)<>1 this is no A// boot disk
2259 6104 AA                    TAX   
2260 6105 CA                    DEX   
2261 6106 D0 0A                 BNE   booterr
2262 6108              *
2263 6108 AF 01 08 00           LDA   >$801                    ;If $801 is zero, no boot
2264 610C F0 04                 BEQ   booterr
2265 610E              *
2266 610E              * It all looks okay.  Jump to the code with N0 in X.
2267 610E              *
2268 610E A2 50                 LDX   #$50                     ;always slot 5 unit
2269 6110 18                    CLC                            ;no boot error
2270 6111 6B                    RTL                            ;back to bank 0
2271 6112              *
2272 6112              *
2273 6112              BOOTERR  EQU   *
2274 6112 18                    CLC                            ;set native
2275 6113 FB                    XCE   
2276 6114 08                    PHP                            ;save his
2277 6115 E2 30                 SEP   #$30
2278 6117 A5 01                 LDA   loc1                     ;was this an auto boot ?
2279 6119 CF F8 07 00           CMP   >mslot
2280 611D F0 40                 BEQ   auto0
2281 611F              *
2282 611F              * The boot failed and the user specifically requested the boot.
2283 611F              * Give him a message pinpointing the problem (if possible).
2284 611F              *
2285 611F 20 26 60              JSR   SetBank0                 ;data bank to $00
2286 6122 AD 2D C0              LDA   |SltRomSel               ;enable slots 5 & 6
2287 6125 48                    PHA                            ;but save it first
2288 6126 29 9F                 AND   #%10011111
2289 6128 8D 2D C0              STA   |SltRomSel
2290 612B AD 68 C0              LDA   |StateReg                ;save away the state register
2291 612E 48                    PHA   
2292 612F A9 08                 LDA   #%00001000
2293 6131 8D 68 C0              STA   |StateReg
2294 6134 38                    SEC                            ;have to go to emulation mode
2295 6135 FB                    XCE   
2296 6136 08                    PHP                            ;but save our mode
2297 6137 22 85 C5 00           JSL   C5Bootm
2298 613B 28                    PLP                            ;and back to native mode
2299 613C FB                    XCE   
2300 613D A2 00                 LDX   #0                       ;Antic an I/O error
2301 613F              *
2302 613F AF B1 0F E1           LDA   >retry                   ;get back the unadulterated error
2303 6143 D0 02                 BNE   bend1
2304 6145 A2 01                 LDX   #1                       ;non bootable disk
2305 6147              *
2306 6147 C9 28        BEND1    CMP   #NoDrive
2307 6149 D0 02                 BNE   bend2
2308 614B A2 02                 LDX   #2                       ;No drive connected
2309 614D              *
2310 614D C9 2F        BEND2    CMP   #Offline
2311 614F D0 02                 BNE   bend3
2312 6151 A2 03                 LDX   #3
2313 6153 8A           BEND3    TXA   
2314 6154 20 80 C0              JSR   |PrintMsg
2315 6157 68                    PLA   
2316 6158 8D 68 C0              STA   |STateReg
2317 615B 68                    PLA                            ;restore slot rom selection
2318 615C 8D 2D C0              STA   |SltRomSel
2319 615F              AUTO0    EQU   *
2320 615F A9 27                 LDA   #$27                     ;I/O error
2321 6161 28                    PLP                            ;restore his
2322 6162 FB                    XCE   
2323 6163 38                    SEC                            ;set error flag
2324 6164 6B                    RTL   
2325 6165              *
2326 6165              *
2327 6165 01 50 00 08  BOOTTAB  DC B:READCMD,$50,0,8,0,0       ;Read from 1st; blk0->$801
2328 616B              *
2329 616B                       TITLE 'Cold RESET Initialization'
2330 616B              ********************************************************************
2331 616B              *
2332 616B              * Called from monitor via PROCINIT equate
2333 616B              *
2334 616B              * This routine is used to setup the SmartBus driver and reset
2335 616B              * the SmartBuss devices, assign their ID's and assign ID's by
2336 616B              * making INIT calls to the AppleDisk 3.5 driver routine.
2337 616B              ********************************************************************
2338 616B              RESET    EQU   *
2339 616B 08                    PHP                            ;save interrupt environment
2340 616C 78                    SEI                            ;and disable 'til done reset
2341 616D A3 01                 LDA   1,s
2342 616F 8F C9 0F E1           STA   >IntEnbl                 ; don't forget the flag
2343 6173 8B                    PHB   
2344 6174 20 2B 60              JSR   SetBankE1                ;Data Bank = $E1
2345 6177 20 31 60              JSR   SavSysZP
2346 617A AF 36 C0 00           LDA   >cyareg                  ;save CYA
2347 617E 48                    PHA   
2348 617F 29 FB                 AND   #%11111011               ;fast mode & disable slot 6 motor detect
2349 6181 09 80                 ORA   #%10000000
2350 6183 8D 36 C0              STA   |cyareg
2351 6186 8B                    PHB   
2352 6187 A9 00                 LDA   #%00000000               ;clear the entire access flag
2353 6189 8F CD 0F E1           STA   >AccessFlg
2354 618D 8F CE 0F E1           STA   >AccessFlg+1
2355 6191              *
2356 6191              * Now determine which type of AssignID to do
2357 6191 AF B6 0F E1           LDA   >Power1                  ;is this a PwrUp or Cold Reset
2358 6195 49 FF                 EOR   #$FF
2359 6197 CF B7 0F E1           CMP   >Power2
2360 619B D0 04                 BNE   @10                      ;it a PwrUp
2361 619D A9 40                 LDA   #ColdReset               ;this is almost a 'major' reset
2362 619F 80 02                 BRA   @20
2363 61A1 A9 00        @10      LDA   #PwrUpReset              ;This is a 'MAJOR' reset
2364 61A3 20 03 5F     @20      JSR   AssignID                 ;assign SmartBuss and AppleDIsk ID's
2365 61A6 20 D0 5E              JSR   RestoreIWM               ;set IWM for Disk][
2366 61A9 AB                    PLB   
2367 61AA 68                    PLA                            ;restore CYA
2368 61AB 8D 36 C0              STA   |cyareg
2369 61AE 20 63 60              JSR   ResSysZP
2370 61B1 AB                    PLB   
2371 61B2 28                    PLP                            ;restore interrupt environment
2372 61B3 60                    RTS                            ;
2373 61B4              *
2374 61B4                       TITLE 'Calling the RamDisk'
2375 61B4              ***************************************************************
2376 61B4              *
2377 61B4              * This routine makes a tool call to the ramdisk.
2378 61B4              * If auxmem is switched in, main memory is selected,
2379 61B4              * and the buffer address is adjusted as neccessary.
2380 61B4              *
2381 61B4              ***************************************************************
2382 61B4              RAMDISK  EQU   *
2383 61B4 8B                    PHB                            ; save and set to $E1
2384 61B5 20 2B 60              JSR   SetBankE1
2385 61B8 AD 68 C0              LDA   |StateReg                ; save the system state
2386 61BB 48                    PHA   
2387 61BC A5 45                 LDA   CMDCode                  ; get the command #
2388 61BE 29 3F                 AND   #$3F
2389 61C0 AA                    TAX   
2390 61C1              *
2391 61C1              * Now check parmcnt for RamDisk toolset
2392 61C1 BF 9B C5 00           LDA   >parmctab,x
2393 61C5 29 7F                 AND   #$7f                     ;get parm count
2394 61C7 E0 05                 CPX   #Initcmd
2395 61C9 D0 01                 BNE   @10
2396 61CB 1A                    INC   a                        ;add 1 if its an INIT cmd
2397 61CC C5 46        @10      CMP   CMDPcount
2398 61CE F0 06                 BEQ   @20
2399 61D0 A9 04                 LDA   #BadPcnt                 ;($04)
2400 61D2 85 50                 STA   statbyte
2401 61D4 80 2F                 BRA   @80
2402 61D6 C2 30        @20      REP   #$30                     ; 16 bit 'm' and 'x'
2403 61D8                       LONGA ON
2404 61D8                       LONGI ON
2405 61D8 A9 FC 1E              LDA   #CmdXfrDir               ; determine xfer direction
2406 61DB              @30      EQU   *
2407 61DB 6A                    ROR   a
2408 61DC CA                    DEX   
2409 61DD 10 FC                 BPL   @30                      ; if C = 0, then destination = host
2410 61DF E2 30                 SEP   #$30                     ; 8 bit 'm' & 'x'
2411 61E1                       LONGA OFF
2412 61E1                       LONGI OFF
2413 61E1 AD 68 C0              LDA   |StateReg
2414 61E4 29 30                 AND   #%00110000               ; RAMRD, RAMWRT ?
2415 61E6 F0 12                 BEQ   @60                      ; no
2416 61E8 B0 09                 BCS   @50                      ; if destination = device
2417 61EA              @40      EQU   *                        ; else destination = host
2418 61EA 29 10                 AND   #%00010000               ; if RAMWRT is off, no futz
2419 61EC F0 0C                 BEQ   @60
2420 61EE 20 11 62              JSR   FutzAddr                 ; well go do it
2421 61F1 80 07                 BRA   @60
2422 61F3              @50      EQU   *
2423 61F3 29 20                 AND   #%00100000               ; if RAMRD is off, no futz
2424 61F5 F0 03                 BEQ   @60
2425 61F7 20 11 62              JSR   FutzAddr                 ; well go do it
2426 61FA              @60      EQU   *
2427 61FA
2428 61FA              *
2429 61FA              * Now call the RAMDISK
2430 61FA              *
2431 61FA C2 30                 REP   #$30                     ; 16 bit 'm' and 'x'
2432 61FC                       LONGA ON
2433 61FC                       LONGI ON
2434 61FC A2 0D 0A              LDX   #$0A0D                   ; RAMDISK tool call
2435 61FF 22 00 00 E1           JSL   >$E10000
2436 6203 E2 30                 SEP   #$30                     ; 8 bit 'm' and 'x'
2437 6205                       LONGA OFF
2438 6205                       LONGI OFF
2439 6205 68           @80      PLA                            ; restore state
2440 6206 8D 68 C0              STA   |StateReg
2441 6209 AB                    PLB   
2442 620A 18                    CLC   
2443 620B A5 50                 LDA   statbyte                 ; did ramdisk fail
2444 620D F0 01                 BEQ   @90                      ; if no fail
2445 620F 38                    SEC                            ; else flag error
2446 6210              @90      EQU   *
2447 6210 60                    RTS   
2448 6211
2449 6211              *
2450 6211              * This routine adjusts the address and
2451 6211              * system state if neccessary.
2452 6211              *
2453 6211              FUTZADDR EQU   *
2454 6211 A5 44                 LDA   ExtBuff+2                ; get the bank address
2455 6213 F0 04                 BEQ   FutzIt                   ; adjust address if bank 0
2456 6215 C9 E0                 CMP   #$E0                     ; or bank E0
2457 6217 D0 11                 BNE   NoAddFutz                ; dont futz if not 0 or E0
2458 6219              FUTZIT   EQU   *
2459 6219 A9 30                 LDA   #%00110000               ; switch to main
2460 621B 1C 68 C0              TRB   |StateReg
2461 621E A5 43                 LDA   ExtBuff+1                ; get A8-15
2462 6220 C9 D0                 CMP   #$D0                     ; is it in the LC
2463 6222 B0 06                 BGE   NoAddFutz                ; yes
2464 6224 C9 02                 CMP   #$02                     ; page 0 or 1
2465 6226 90 02                 BLT   NoAddFutz                ; no
2466 6228 E6 44                 INC   ExtBuff+2                ; if even, make it odd
2467 622A              NOADDFUTZ EQU   *
2468 622A 60                    RTS   
2469 622B                       TITLE 'Calling the ROMDISK'
2470 622B              ********************************************************
2471 622B              *
2472 622B              * This routine will search for the RomDisk
2473 622B              * driver on an INIT call only.  All other
2474 622B              * calls will dispatch to the RomDisk driver.
2475 622B              *
2476 622B              ********************************************************
2477 622B              ROMDISK  EQU   *
2478 622B A5 45                 LDA   CMDCode                  ; is it an init call?
2479 622D 29 3F                 AND   #$3F
2480 622F C9 05                 CMP   #InitCMD
2481 6231 D0 11                 BNE   @20                      ; no, then dont search
2482 6233 A2 05                 LDX   #5
2483 6235              @10      EQU   *
2484 6235 BF 00 00 F0           LDA   >$F00000,x               ; get romdisk string
2485 6239 DF 5B 62 FF           CMP   >rdid,x                  ; and check it
2486 623D D0 16                 BNE   @40                      ; if not same, bomb out
2487 623F CA                    DEX   
2488 6240 10 F3                 BPL   @10
2489 6242              ; The following line of code was the last change made to the Tenspeed FF ROM before Final
2490 6242 80 06                 BRA   @25                      ; THE VERY COSTLY MISSING BRA INSTRUCTION JOA MAY 89
2491 6244 AF BD 0F E1  @20      LDA   >ROMUnit                 ;does a ROMDisk exist?
2492 6248 F0 0B                 BEQ   @40                      ;nope. so return NoDevice Connected!
2493 624A 22 07 00 F0  @25      JSL   >RomDriver               ; dispatch to romdisk
2494 624E 18                    CLC   
2495 624F A5 50                 LDA   statbyte
2496 6251 F0 01                 BEQ   @30
2497 6253 38                    SEC   
2498 6254              @30      EQU   *
2499 6254 60                    RTS   
2500 6255              @40      EQU   *
2501 6255 38                    SEC                            ; flag error
2502 6256 A9 28                 LDA   #$28
2503 6258 85 50                 STA   StatByte
2504 625A 60                    RTS   
2505 625B                       MSB   on
2506 625B D2 CF CD C4  RDID     DC B:'ROMDIS'
